/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.editors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.sourceforge.pmd.eclipse.ui.editors.SyntaxData;
import net.sourceforge.pmd.util.StringUtil;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

public class StyleExtractor {
    private SyntaxData syntaxData;
    private List<int[]> commentOffsets;
    private static final Color COMMENT_COLOR = Display.getCurrent().getSystemColor(6);
    private static final Color REFERENCED_VAR_COLOR = Display.getCurrent().getSystemColor(6);
    private static final Color UNREFERENCED_VAR_COLOR = Display.getCurrent().getSystemColor(7);
    private static final Color COMMENT_BACKGROUND = Display.getCurrent().getSystemColor(1);
    private static final Color PUNCTUATION_COLOR = Display.getCurrent().getSystemColor(2);
    private static final Color KEYWORD_COLOR = Display.getCurrent().getSystemColor(12);
    private static final Color STRING_COLOR = Display.getCurrent().getSystemColor(9);

    public StyleExtractor(SyntaxData theSyntaxData) {
        this.syntaxData = theSyntaxData;
        this.commentOffsets = new LinkedList<int[]>();
    }

    public void syntax(SyntaxData theSyntax) {
        this.syntaxData = theSyntax;
    }

    public void refreshMultilineComments(String text) {
        this.commentOffsets.clear();
        if (this.syntaxData != null) {
            int pos = text.indexOf(this.syntaxData.getMultiLineCommentStart());
            while (pos > -1) {
                int[] offsets = new int[]{pos, (pos = text.indexOf(this.syntaxData.getMultiLineCommentEnd(), pos)) == -1 ? text.length() - 1 : pos + this.syntaxData.getMultiLineCommentEnd().length() - 1};
                pos = offsets[1];
                this.commentOffsets.add(offsets);
                pos = text.indexOf(this.syntaxData.getMultiLineCommentStart(), pos);
            }
        }
    }

    private int getBeginsInsideComment(int start, int length) {
        int index = -1;
        int i = 0;
        int n = this.commentOffsets.size();
        while (i < n) {
            int[] offsets = this.commentOffsets.get(i);
            if (offsets[0] > start + length) break;
            if (offsets[0] <= start && offsets[1] >= start) {
                index = offsets[1] > start + length ? start + length : offsets[1] + this.syntaxData.getMultiLineCommentEnd().length() - 1;
            }
            ++i;
        }
        return index;
    }

    private boolean isDefinedVariable(String text) {
        return StringUtil.isNotEmpty((String)text);
    }

    private boolean atMultiLineCommentStart(String text, int position) {
        return text.indexOf(this.syntaxData.getMultiLineCommentStart(), position) == position;
    }

    private boolean atStringStart(String text, int position) {
        return text.indexOf(this.syntaxData.stringStart, position) == position;
    }

    private boolean atVarnameReference(String text, int position) {
        if (this.syntaxData.varnameReference == null) {
            return false;
        }
        return text.indexOf(this.syntaxData.varnameReference, position) == position;
    }

    private boolean atSingleLineComment(String text, int position) {
        if (this.syntaxData.getComment() == null) {
            return false;
        }
        return text.indexOf(this.syntaxData.getComment(), position) == position;
    }

    private int getKeywordEnd(String lineText, int start) {
        int length = lineText.length();
        StringBuilder buf = new StringBuilder(length);
        int i = start;
        while (i < length && Character.isLetter(lineText.charAt(i))) {
            buf.append(lineText.charAt(i));
            ++i;
        }
        return this.syntaxData.isKeyword(buf.toString()) ? i : 0 - i;
    }

    public List<StyleRange> stylesFor(String text, int offset, int length, String lineSeparator) {
        if (this.syntaxData == null) {
            return Collections.emptyList();
        }
        String content = text.substring(offset, offset + length);
        String[] lines = content.split(lineSeparator);
        ArrayList<StyleRange> styles = new ArrayList<StyleRange>();
        int separatorLength = lineSeparator.length();
        int currentOffset = offset;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            int lineLength = line.length();
            List<StyleRange> lineStyles = this.lineStylesFor(line, 0, lineLength);
            for (StyleRange sr : lineStyles) {
                sr.start += currentOffset;
            }
            styles.addAll(lineStyles);
            currentOffset += lineLength + separatorLength;
            ++n2;
        }
        return styles;
    }

    public List<StyleRange> lineStylesFor(String lineText, int lineOffset, int length) {
        ArrayList<StyleRange> styles = new ArrayList<StyleRange>();
        int start = 0;
        int mlIndex = this.getBeginsInsideComment(lineOffset, lineText.length());
        if (mlIndex > -1) {
            styles.add(new StyleRange(lineOffset, mlIndex - lineOffset, COMMENT_COLOR, COMMENT_BACKGROUND));
            start = mlIndex;
        }
        while (start < length) {
            if (this.atMultiLineCommentStart(lineText, start)) {
                int endComment = lineText.indexOf(this.syntaxData.getMultiLineCommentEnd(), start);
                endComment = endComment == -1 ? length : (endComment += this.syntaxData.getMultiLineCommentEnd().length());
                styles.add(new StyleRange(lineOffset + start, endComment - start, COMMENT_COLOR, COMMENT_BACKGROUND));
                start = endComment;
                continue;
            }
            if (this.atStringStart(lineText, start)) {
                int endString = lineText.indexOf(this.syntaxData.stringEnd, start + 1);
                endString = endString == -1 ? length : (endString += this.syntaxData.stringEnd.length());
                styles.add(new StyleRange(lineOffset + start, endString - start, STRING_COLOR, COMMENT_BACKGROUND));
                start = endString;
                continue;
            }
            if (this.atSingleLineComment(lineText, start)) {
                styles.add(new StyleRange(lineOffset + start, length - start, COMMENT_COLOR, COMMENT_BACKGROUND));
                start = length;
                continue;
            }
            if (this.atVarnameReference(lineText, start)) {
                StringBuilder buf = new StringBuilder();
                int i = start + this.syntaxData.getVarnameReference().length();
                while (i < length && Character.isLetter(lineText.charAt(i))) {
                    buf.append(lineText.charAt(i));
                    ++i;
                }
                if (this.isDefinedVariable(buf.toString())) {
                    styles.add(new StyleRange(lineOffset + start, i - start, REFERENCED_VAR_COLOR, null, 1));
                }
                start = i;
                continue;
            }
            if (this.syntaxData.isPunctuation(lineText.charAt(start))) {
                styles.add(new StyleRange(lineOffset + start, 1, PUNCTUATION_COLOR, null));
                ++start;
                continue;
            }
            if (Character.isLetter(lineText.charAt(start))) {
                int kwEnd = this.getKeywordEnd(lineText, start);
                if (kwEnd > start) {
                    styles.add(new StyleRange(lineOffset + start, kwEnd - start, KEYWORD_COLOR, null));
                }
                start = Math.abs(kwEnd);
                continue;
            }
            ++start;
        }
        return styles;
    }
}

