/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.template;

import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansProject;
import org.springframework.ide.eclipse.beans.core.model.IBeansModel;
import org.springframework.ide.eclipse.core.SpringCorePreferences;
import org.springframework.ide.eclipse.core.SpringCoreUtils;
import org.springframework.ide.eclipse.wizard.template.JavaProjectConfigurationDescriptor;
import org.springframework.ide.eclipse.wizard.template.NewSpringProjectWizardMessages;
import org.springframework.ide.eclipse.wizard.template.ProjectConfiguration;

public abstract class JavaProjectConfiguration
extends ProjectConfiguration {
    private final JavaProjectConfigurationDescriptor javaDescriptor;

    public JavaProjectConfiguration(JavaProjectConfigurationDescriptor javaDescriptor) {
        this.javaDescriptor = javaDescriptor;
    }

    @Override
    public void configureProject(IProgressMonitor monitor) throws CoreException {
        this.handleJavaConfiguration(monitor);
    }

    protected void handleJavaConfiguration(IProgressMonitor monitor) throws CoreException {
        if (this.javaDescriptor == null) {
            return;
        }
        if (this.getProject() == null) {
            return;
        }
        SpringCorePreferences prefs = SpringCorePreferences.getProjectPreferences((IProject)this.getProject(), (String)"org.springframework.ide.eclipse.beans.core");
        Set<String> configExtensions = this.javaDescriptor.getConfigSuffixes();
        boolean enableImports = this.javaDescriptor.enableImports();
        boolean enableProjectFacets = this.javaDescriptor.enableProjectFacets();
        boolean ignoreMissingNamespaceHandlers = this.javaDescriptor.ignoreMissingNamespaceHandlers();
        boolean loadHandlerFromClasspath = this.javaDescriptor.loadHandlerFromClasspath();
        boolean disableNamespaceCaching = this.javaDescriptor.disableNamespaceCaching();
        boolean useHighestXsdVersion = this.javaDescriptor.useHighestXsdVersion();
        boolean useProjectSettings = this.javaDescriptor.useProjectSettings();
        monitor.beginTask(NewSpringProjectWizardMessages.NewProject_createNewProject, 1000);
        this.configureSpringProject(this.getProject(), configExtensions, enableImports, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
        if (useProjectSettings) {
            prefs.putBoolean("enable.project.preferences", useProjectSettings);
            prefs.putBoolean("default.version.check.classpath", useHighestXsdVersion);
            prefs.putBoolean("loadNamespaceHandlerFromClasspath", loadHandlerFromClasspath);
            prefs.putBoolean("disableCachingForNamespaceLoadingFromClasspath", disableNamespaceCaching);
        }
        prefs.putBoolean("ignoreMissingNamespaceHandler", ignoreMissingNamespaceHandlers);
        if (enableProjectFacets) {
            SpringCoreUtils.addProjectNature((IProject)this.getProject(), (String)"org.eclipse.wst.common.project.facet.core.nature", (IProgressMonitor)monitor);
        }
        monitor.done();
    }

    protected void configureSpringProject(IProject projectHandle, Set<String> configExtensions, boolean enableImports, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        try {
            monitor.beginTask(NewSpringProjectWizardMessages.NewProject_createProject, 4);
            SpringCoreUtils.addProjectNature((IProject)projectHandle, (String)"org.springframework.ide.eclipse.core.springnature", (IProgressMonitor)monitor);
            monitor.worked(2);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            IBeansModel model = BeansCorePlugin.getModel();
            BeansProject project = new BeansProject(model, projectHandle);
            project.setConfigSuffixes(configExtensions);
            project.setImportsEnabled(enableImports);
            project.saveDescription();
            monitor.worked(2);
        }
        finally {
            monitor.done();
        }
    }
}

