/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.ui.preferences;

import com.atlassian.connector.eclipse.ui.AtlassianUiPlugin;
import java.io.IOException;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.prefs.BackingStoreException;

public class EclipsePreferencesAdapter
implements IPreferenceStore,
IPersistentPreferenceStore {
    private final ListenerList fListeners = new ListenerList(1);
    private final PreferenceChangeListener fListener = new PreferenceChangeListener();
    private final IEclipsePreferences fPreferences;
    private boolean fSilent;
    private final IScopeContext fContext;
    private final String defaultQualifier;
    private final IScopeContext defaultContext;

    public EclipsePreferencesAdapter(IScopeContext context, String qualifier) {
        this.fContext = context;
        this.fPreferences = this.fContext.getNode(qualifier);
        this.defaultQualifier = qualifier;
        this.defaultContext = new DefaultScope();
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        if (this.fListeners.size() == 0) {
            this.fPreferences.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this.fListener);
        }
        this.fListeners.add((Object)listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.fListeners.remove((Object)listener);
        if (this.fListeners.size() == 0) {
            this.fPreferences.removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this.fListener);
        }
    }

    public boolean contains(String name) {
        try {
            return ArrayUtils.contains((Object[])this.fPreferences.keys(), (Object)name);
        }
        catch (BackingStoreException backingStoreException) {
            return false;
        }
    }

    public void firePropertyChangeEvent(String name, Object oldValue, Object newValue) {
        if (!this.fSilent) {
            Object[] listeners;
            final PropertyChangeEvent event = new PropertyChangeEvent((Object)this, name, oldValue, newValue);
            Object[] objectArray = listeners = this.fListeners.getListeners();
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener2 = objectArray[n2];
                final IPropertyChangeListener listener = (IPropertyChangeListener)listener2;
                Runnable runnable = new Runnable(){

                    public void run() {
                        listener.propertyChange(event);
                    }
                };
                if (Display.getCurrent() != null) {
                    runnable.run();
                } else {
                    Shell shell = AtlassianUiPlugin.getActiveWorkbenchShell();
                    Display display = shell != null ? shell.getDisplay() : Display.getDefault();
                    display.asyncExec(runnable);
                }
                ++n2;
            }
        }
    }

    public boolean getBoolean(String name) {
        return this.fPreferences.getBoolean(name, this.getDefaultBoolean(name));
    }

    public boolean getDefaultBoolean(String name) {
        return this.getDefaultPreferences().getBoolean(name, false);
    }

    public double getDefaultDouble(String name) {
        return this.getDefaultPreferences().getDouble(name, 0.0);
    }

    public float getDefaultFloat(String name) {
        return this.getDefaultPreferences().getFloat(name, 0.0f);
    }

    public int getDefaultInt(String name) {
        return this.getDefaultPreferences().getInt(name, 0);
    }

    public long getDefaultLong(String name) {
        return this.getDefaultPreferences().getLong(name, 0L);
    }

    public String getDefaultString(String name) {
        return this.getDefaultPreferences().get(name, "");
    }

    public double getDouble(String name) {
        return this.fPreferences.getDouble(name, this.getDefaultDouble(name));
    }

    public float getFloat(String name) {
        return this.fPreferences.getFloat(name, this.getDefaultFloat(name));
    }

    public int getInt(String name) {
        return this.fPreferences.getInt(name, this.getDefaultInt(name));
    }

    public long getLong(String name) {
        return this.fPreferences.getLong(name, this.getDefaultLong(name));
    }

    public String getString(String name) {
        return this.fPreferences.get(name, this.getDefaultString(name));
    }

    public boolean isDefault(String name) {
        return false;
    }

    public boolean needsSaving() {
        try {
            return this.fPreferences.keys().length > 0;
        }
        catch (BackingStoreException backingStoreException) {
            return true;
        }
    }

    public void putValue(String name, String value) {
        try {
            this.fSilent = true;
            this.fPreferences.put(name, value);
        }
        finally {
            this.fSilent = false;
        }
    }

    public void setDefault(String name, double value) {
        this.getDefaultPreferences().putDouble(name, value);
    }

    public void setDefault(String name, float value) {
        this.getDefaultPreferences().putFloat(name, value);
    }

    public void setDefault(String name, int value) {
        this.getDefaultPreferences().putInt(name, value);
    }

    public void setDefault(String name, long value) {
        this.getDefaultPreferences().putLong(name, value);
    }

    public void setDefault(String name, String value) {
        this.getDefaultPreferences().put(name, value);
    }

    public void setDefault(String name, boolean value) {
        this.getDefaultPreferences().putBoolean(name, value);
    }

    public void setToDefault(String name) {
        this.fPreferences.put(name, this.getDefaultString(name));
    }

    public void setValue(String name, double value) {
        this.fPreferences.putDouble(name, value);
    }

    public void setValue(String name, float value) {
        this.fPreferences.putFloat(name, value);
    }

    public void setValue(String name, int value) {
        this.fPreferences.putInt(name, value);
    }

    public void setValue(String name, long value) {
        this.fPreferences.putLong(name, value);
    }

    public void setValue(String name, String value) {
        this.fPreferences.put(name, value);
    }

    public void setValue(String name, boolean value) {
        this.fPreferences.putBoolean(name, value);
    }

    public void save() throws IOException {
        try {
            this.fPreferences.flush();
        }
        catch (BackingStoreException e) {
            throw new IOException(e.getMessage());
        }
    }

    private IEclipsePreferences getDefaultPreferences() {
        return this.defaultContext.getNode(this.defaultQualifier);
    }

    private class PreferenceChangeListener
    implements IEclipsePreferences.IPreferenceChangeListener {
        private PreferenceChangeListener() {
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            EclipsePreferencesAdapter.this.firePropertyChangeEvent(event.getKey(), event.getOldValue(), event.getNewValue());
        }
    }
}

