/*
 * JBoss, the OpenSource EJB server
 * 
 * Distributable under LGPL license. See terms of license at gnu.org.
 */
package javax.resource.spi;

import java.util.EventObject;

/**
 * The ConnectionEvent class provides information about the source of a
 * Connection related event. A ConnectionEvent contains:
 * <ul>
 * 
 * <li>Type of connection event.</li>
 * <li>Managed connection instance that generated the event.</li>
 * <li>Connection handle associated with the managed connection.</li>
 * <li>Optionally an exception indicating an error.</li>
 * </ul>
 * <p>
 * This class is used for the following types of notifications:
 * <ul>
 * 
 * <li>Connection closed</li>
 * <li>Local transaction started</li>
 * <li>Local transaction commited</li>
 * <li>Local transaction rolled back</li>
 * <li>Connection error occurred</li>
 * </ul>
 * @version $Revision: 1.6 $
 */
public class ConnectionEvent extends EventObject
{
   /**
	 * Connection has been closed
	 */
   public static final int CONNECTION_CLOSED = 1;

   /**
	 * Local transaction has been started
	 */
   public static final int LOCAL_TRANSACTION_STARTED = 2;

   /**
	 * Local transaction has been committed
	 */
   public static final int LOCAL_TRANSACTION_COMMITTED = 3;

   /**
	 * Local transaction has been rolled back
	 */
   public static final int LOCAL_TRANSACTION_ROLLEDBACK = 4;

   /**
	 * Connection error has occurred
	 */
   public static final int CONNECTION_ERROR_OCCURRED = 5;

   /** Type of event */
   protected int id;

   /** The exception */
   private Exception e = null;
   /** The connectionHandle */
   private Object connectionHandle = null;

   /**
    * Create a new ConnectionEvent
    *
    * @param source the source of the event
    * @param eid the event id
    */
   public ConnectionEvent(ManagedConnection source, int eid)
   {
      super(source);
      id = eid;
   }

   /**
    * Create a new ConnectionEvent
    *
    * @param source the source of the event
    * @param eid the event id
    * @param exception the exception associated with the event
    */
   public ConnectionEvent(ManagedConnection source, int eid, Exception exception)
   {
      super(source);
      id = eid;
      e = exception;
   }

   /**
	 * Get the event type
    * 
    * @return the event id
	 */
   public int getId()
   {
      return id;
   }

   /**
	 * Get the exception
    * 
    * @return the exception
	 */
   public Exception getException()
   {
      return e;
   }

   /**
	 * Set the ConnectionHandle
    * 
    * @param connectionHandle the connection handle
	 */
   public void setConnectionHandle(Object connectionHandle)
   {
      this.connectionHandle = connectionHandle;
   }

   /**
	 * Get the ConnectionHandle
    * 
    * @return the connection handle
	 */
   public Object getConnectionHandle()
   {
      return connectionHandle;
   }
}