/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxws.binding;

import java.io.IOException;
import java.io.OutputStream;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.invocation.OnewayInvocation;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.ws.core.soap.SOAPBodyImpl;
import org.jboss.ws.core.soap.SOAPMessageImpl;
import org.jboss.ws.extensions.json.BadgerFishDOMDocumentSerializer;
import org.w3c.dom.Element;

public class JsonMessageMarshaller
implements Marshaller {
    private static Logger log = Logger.getLogger(JsonMessageMarshaller.class);

    public void write(Object dataObject, OutputStream output) throws IOException {
        if (dataObject instanceof InvocationRequest) {
            dataObject = ((InvocationRequest)dataObject).getParameter();
        }
        if (dataObject instanceof OnewayInvocation) {
            dataObject = ((OnewayInvocation)dataObject).getParameters()[0];
        }
        if (!(dataObject instanceof SOAPMessageImpl)) {
            throw new IllegalArgumentException("Not a SOAPMessageImpl: " + dataObject);
        }
        try {
            SOAPMessage soapMessage = (SOAPMessage)dataObject;
            SOAPBodyImpl soapBody = (SOAPBodyImpl)soapMessage.getSOAPBody();
            SOAPBodyElement payload = soapBody.getBodyElement();
            new BadgerFishDOMDocumentSerializer(output).serialize((Element)payload);
        }
        catch (SOAPException ex) {
            IOException ioex = new IOException("Cannot serialize: " + dataObject);
            ioex.initCause(ex);
            throw ioex;
        }
    }

    public Marshaller cloneMarshaller() throws CloneNotSupportedException {
        return new JsonMessageMarshaller();
    }
}

