/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.properties.model;

import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.beans.ui.properties.model.PropertiesConfig;
import org.springframework.ide.eclipse.beans.ui.properties.model.PropertiesConfigSet;
import org.springframework.ide.eclipse.beans.ui.properties.model.PropertiesJavaConfig;
import org.springframework.ide.eclipse.beans.ui.properties.model.PropertiesProject;
import org.springframework.ide.eclipse.core.java.JdtUtils;

public class PropertiesConfigFactory {
    public static final String JAVA_CONFIG_TYPE = "java:";

    public static IBeansConfig create(PropertiesProject project, String name, IBeansConfig.Type type) {
        if (name != null && name.startsWith(JAVA_CONFIG_TYPE)) {
            String className = name.substring(JAVA_CONFIG_TYPE.length());
            IJavaProject javaProject = JdtUtils.getJavaProject((IProject)project.getProject());
            try {
                IType configClass = javaProject.findType(className);
                return new PropertiesJavaConfig(project, configClass, className, IBeansConfig.Type.MANUAL);
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        } else {
            String projectPath;
            if (name.length() > 0 && name.charAt(0) == '/' && name.startsWith(projectPath = String.valueOf('/') + project.getElementName() + '/')) {
                name = name.substring(projectPath.length());
            }
            return new PropertiesConfig(project, name, IBeansConfig.Type.MANUAL);
        }
        return null;
    }

    public static IBeansConfig create(PropertiesConfigSet set, String name, IBeansConfig.Type type) {
        if (name != null && name.startsWith(JAVA_CONFIG_TYPE)) {
            String className = name.substring(JAVA_CONFIG_TYPE.length());
            IBeansProject beansProject = (IBeansProject)set.getElementParent();
            IJavaProject javaProject = JdtUtils.getJavaProject((IProject)beansProject.getProject());
            try {
                IType configClass = javaProject.findType(className);
                return new PropertiesJavaConfig(set, configClass, className, IBeansConfig.Type.MANUAL);
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        } else {
            return new PropertiesConfig(set, name, IBeansConfig.Type.MANUAL);
        }
        return null;
    }
}

