/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.properties;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JarEntryDirectory;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.springframework.ide.eclipse.core.io.ZipEntryStorage;
import org.springframework.ide.eclipse.core.java.JdtUtils;

public class NonJavaResourceContentProvider
implements ITreeContentProvider {
    public static final Object[] NO_CHILDREN = new Object[0];
    private static final Path JVM_CLASSPATH_CONTAINER = new Path("org.eclipse.jdt.launching.JRE_CONTAINER");

    public void dispose() {
    }

    public Object[] getChildren(Object element) {
        if (!this.exists(element)) {
            return NO_CHILDREN;
        }
        try {
            IProject project;
            if (element instanceof IProject && JdtUtils.isJavaProject((IResource)(project = (IProject)element))) {
                element = JavaCore.create((IProject)project);
            }
            if (element instanceof IJavaProject) {
                return this.getPackageFragmentRoots((IJavaProject)element);
            }
            if (element instanceof IProject) {
                return this.getResources((IContainer)((IProject)element));
            }
            if (element instanceof IPackageFragmentRoot) {
                return this.getPackageFragments((IPackageFragmentRoot)element);
            }
            if (element instanceof IPackageFragment) {
                return this.getPackageContents((IPackageFragment)element);
            }
            if (element instanceof IFolder) {
                return this.getResources((IContainer)((IFolder)element));
            }
            if (element instanceof JarEntryDirectory) {
                return this.getResources((JarEntryDirectory)element);
            }
        }
        catch (JavaModelException javaModelException) {
            return NO_CHILDREN;
        }
        return NO_CHILDREN;
    }

    public Object[] getElements(Object parent) {
        return this.getChildren(parent);
    }

    public Object getParent(Object element) {
        if (!this.exists(element)) {
            return null;
        }
        return this.internalGetParent(element);
    }

    public boolean hasChildren(Object element) {
        Object[] children;
        IJavaProject javaProject;
        IProject project;
        if (element instanceof IProject && !(project = (IProject)element).isOpen()) {
            return false;
        }
        if (element instanceof IJavaProject && !(javaProject = (IJavaProject)element).getProject().isOpen()) {
            return false;
        }
        if (element instanceof IParent) {
            try {
                if (((IParent)element).hasChildren()) {
                    return true;
                }
            }
            catch (JavaModelException javaModelException) {
                return true;
            }
        }
        return (children = this.getChildren(element)) != null && children.length > 0;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    private Object[] getNonJavaResources(IPackageFragment fragment) throws JavaModelException {
        Object[] nonJavaResources = fragment.getNonJavaResources();
        IPackageFragmentRoot root = (IPackageFragmentRoot)fragment.getAncestor(3);
        if (root != null && root.getKind() == 2) {
            int i = 0;
            while (i < nonJavaResources.length) {
                Object resource = nonJavaResources[i];
                if (resource instanceof IFile) {
                    nonJavaResources[i] = resource;
                } else if (resource instanceof IStorage && root.getResource() instanceof IFile) {
                    IStorage storage = (IStorage)resource;
                    nonJavaResources[i] = new ZipEntryStorage((IFile)root.getResource(), storage.getFullPath().toString());
                }
                ++i;
            }
        }
        return nonJavaResources;
    }

    private Object[] getNonJavaResources(IPackageFragmentRoot root) throws JavaModelException {
        Object[] nonJavaResources = root.getNonJavaResources();
        if (root.getKind() == 2 && root.getResource() instanceof IFile) {
            int i = 0;
            while (i < nonJavaResources.length) {
                Object resource = nonJavaResources[i];
                if (resource instanceof IStorage) {
                    IStorage storage = (IStorage)resource;
                    nonJavaResources[i] = new ZipEntryStorage((IFile)root.getResource(), storage.getFullPath().toString());
                }
                ++i;
            }
        }
        return nonJavaResources;
    }

    private Object[] getPackageContents(IPackageFragment fragment) throws JavaModelException {
        return this.getNonJavaResources(fragment);
    }

    private Object[] getPackageFragments(IPackageFragmentRoot root) throws JavaModelException {
        Object[] fragments = root.getChildren();
        Object[] nonJavaResources = this.getNonJavaResources(root);
        if (nonJavaResources == null) {
            return fragments;
        }
        return NonJavaResourceContentProvider.concatenate(fragments, nonJavaResources);
    }

    private Object[] getResources(IContainer container) {
        try {
            Object[] members = container.members();
            IJavaProject javaProject = JavaCore.create((IProject)container.getProject());
            if (javaProject == null || !javaProject.exists()) {
                return members;
            }
            boolean isFolderOnClasspath = javaProject.isOnClasspath((IResource)container);
            ArrayList<Object> nonJavaResources = new ArrayList<Object>();
            Object[] objectArray = members;
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                Object member = objectArray[n2];
                if (isFolderOnClasspath) {
                    if (javaProject.findPackageFragmentRoot(member.getFullPath()) == null) {
                        nonJavaResources.add(member);
                    }
                } else if (!javaProject.isOnClasspath((IResource)member)) {
                    nonJavaResources.add(member);
                }
                ++n2;
            }
            return nonJavaResources.toArray();
        }
        catch (CoreException coreException) {
            return NO_CHILDREN;
        }
    }

    private Object[] getResources(JarEntryDirectory element) {
        return element.getChildren();
    }

    protected boolean exists(Object element) {
        if (element == null) {
            return false;
        }
        if (element instanceof IResource) {
            return ((IResource)element).exists();
        }
        if (element instanceof IJavaElement) {
            return ((IJavaElement)element).exists();
        }
        return true;
    }

    protected Object[] getJavaProjects(IJavaModel model) throws JavaModelException {
        return model.getJavaProjects();
    }

    protected Object[] getPackageFragmentRoots(IJavaProject project) throws JavaModelException {
        if (!project.getProject().isOpen()) {
            return NO_CHILDREN;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        IPackageFragmentRoot[] iPackageFragmentRootArray = project.getPackageFragmentRoots();
        int n = iPackageFragmentRootArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
            if (!JVM_CLASSPATH_CONTAINER.isPrefixOf(root.getRawClasspathEntry().getPath())) {
                if (this.isProjectPackageFragmentRoot(root)) {
                    IJavaElement[] iJavaElementArray = root.getChildren();
                    int n3 = iJavaElementArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IJavaElement element = iJavaElementArray[n4];
                        list.add(element);
                        ++n4;
                    }
                } else if (this.hasChildren(root)) {
                    list.add(root);
                }
            }
            ++n2;
        }
        return NonJavaResourceContentProvider.concatenate(list.toArray(), project.getNonJavaResources());
    }

    protected Object internalGetParent(Object element) {
        if (element instanceof IResource) {
            IContainer parent = ((IResource)element).getParent();
            IJavaElement jParent = JavaCore.create((IResource)parent);
            if (jParent != null && jParent.exists()) {
                return jParent;
            }
            return parent;
        }
        if (element instanceof IJavaElement) {
            IJavaElement parent = ((IJavaElement)element).getParent();
            if (element instanceof IPackageFragment) {
                return this.skipProjectPackageFragmentRoot((IPackageFragmentRoot)parent);
            }
            return parent;
        }
        return null;
    }

    protected boolean isClasspathChange(IJavaElementDelta delta) {
        if (delta.getElement().getElementType() != 3) {
            return false;
        }
        int flags = delta.getFlags();
        return delta.getKind() == 4 && (flags & 0x40) != 0 || (flags & 0x80) != 0 || (flags & 0x100) != 0;
    }

    protected boolean isInternalLibrary(IJavaProject project, IPackageFragmentRoot root) {
        if (root.isArchive()) {
            IResource resource = root.getResource();
            if (resource != null) {
                IProject jarProject = resource.getProject();
                IProject container = root.getJavaProject().getProject();
                return container.equals((Object)jarProject);
            }
            return false;
        }
        return true;
    }

    protected boolean isPackageFragmentEmpty(IJavaElement element) throws JavaModelException {
        IPackageFragment fragment;
        return element instanceof IPackageFragment && (fragment = (IPackageFragment)element).exists() && !fragment.hasChildren() && fragment.getNonJavaResources().length <= 0 && fragment.hasSubpackages();
    }

    protected boolean isProjectPackageFragmentRoot(IPackageFragmentRoot root) {
        IResource resource = root.getResource();
        return resource instanceof IProject;
    }

    protected Object skipProjectPackageFragmentRoot(IPackageFragmentRoot root) {
        if (this.isProjectPackageFragmentRoot(root)) {
            return root.getParent();
        }
        return root;
    }

    protected static Object[] concatenate(Object[] a1, Object[] a2) {
        int a1Len = a1.length;
        int a2Len = a2.length;
        Object[] res = new Object[a1Len + a2Len];
        System.arraycopy(a1, 0, res, 0, a1Len);
        System.arraycopy(a2, 0, res, a1Len, a2Len);
        return res;
    }
}

