/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.editor.namespaces;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.springframework.ide.eclipse.beans.ui.editor.namespaces.IReferenceableElementsLocator;
import org.springframework.ide.eclipse.beans.ui.editor.util.BeansEditorUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultReferenceableElementsLocator
implements IReferenceableElementsLocator {
    @Override
    public Map<String, Set<Node>> getReferenceableElements(Document document, IFile file) {
        HashMap<String, Set<Node>> nodes = new HashMap<String, Set<Node>>();
        NodeList childNodes = document.getDocumentElement().getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node node = childNodes.item(i);
            if (BeansEditorUtils.hasAttribute(node, "id")) {
                DefaultReferenceableElementsLocator.addNodeToMap(BeansEditorUtils.getAttribute(node, "id"), node, nodes);
            } else if (BeansEditorUtils.hasAttribute(node, "alias")) {
                DefaultReferenceableElementsLocator.addNodeToMap(BeansEditorUtils.getAttribute(node, "alias"), node, nodes);
            }
            ++i;
        }
        return nodes;
    }

    private static void addNodeToMap(String name, Node node, Map<String, Set<Node>> nodes) {
        Set<Node> matchedNodes = nodes.get(name);
        if (matchedNodes == null) {
            matchedNodes = new HashSet<Node>();
            nodes.put(name, matchedNodes);
        }
        matchedNodes.add(node);
    }
}

