/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.launch.util;

import java.util.Collections;
import java.util.List;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.springframework.ide.eclipse.boot.launch.util.ILaunchConfigurationTabSection;
import org.springsource.ide.eclipse.commons.livexp.core.CompositeValidator;
import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;
import org.springsource.ide.eclipse.commons.livexp.core.OrExpression;
import org.springsource.ide.eclipse.commons.livexp.core.ValidationResult;
import org.springsource.ide.eclipse.commons.livexp.core.ValueListener;
import org.springsource.ide.eclipse.commons.livexp.ui.Disposable;
import org.springsource.ide.eclipse.commons.livexp.ui.IPageSection;
import org.springsource.ide.eclipse.commons.livexp.ui.IPageWithSections;

public abstract class LaunchConfigurationTabWithSections
extends AbstractLaunchConfigurationTab
implements IPageWithSections,
Disposable {
    private List<IPageSection> sections = null;
    private boolean disposed = false;

    protected abstract List<IPageSection> createSections();

    public final void createControl(Composite parent) {
        Composite page = SWTFactory.createComposite((Composite)parent, (Font)parent.getFont(), (int)1, (int)1, (int)1808);
        CompositeValidator validator = new CompositeValidator();
        OrExpression dirtyState = new OrExpression();
        for (IPageSection s : this.getSections()) {
            s.createContents(page);
            validator.addChild(s.getValidator());
            if (!(s instanceof ILaunchConfigurationTabSection)) continue;
            dirtyState.addChild(((ILaunchConfigurationTabSection)s).getDirtyState());
        }
        this.setControl((Control)page);
        validator.addListener((ValueListener)new ValueListener<ValidationResult>(){

            public void gotValue(LiveExpression<ValidationResult> exp, ValidationResult value) {
                if (value.isOk()) {
                    LaunchConfigurationTabWithSections.this.setErrorMessage(null);
                    LaunchConfigurationTabWithSections.this.setWarningMessage(null);
                    LaunchConfigurationTabWithSections.this.scheduleUpdateJob();
                } else if (value.status == 2) {
                    LaunchConfigurationTabWithSections.this.setErrorMessage(null);
                    LaunchConfigurationTabWithSections.this.setWarningMessage(value.msg);
                    LaunchConfigurationTabWithSections.this.scheduleUpdateJob();
                } else {
                    LaunchConfigurationTabWithSections.this.setWarningMessage(null);
                    LaunchConfigurationTabWithSections.this.setErrorMessage(value.msg);
                    LaunchConfigurationTabWithSections.this.scheduleUpdateJob();
                }
            }
        });
        dirtyState.addListener((ValueListener)new ValueListener<Boolean>(){

            public void gotValue(LiveExpression<Boolean> exp, Boolean dirty) {
                if (dirty != null && dirty != LaunchConfigurationTabWithSections.this.isDirty()) {
                    LaunchConfigurationTabWithSections.this.setDirty(dirty);
                    if (dirty.booleanValue()) {
                        LaunchConfigurationTabWithSections.this.scheduleUpdateJob();
                    }
                }
            }
        });
    }

    protected void scheduleUpdateJob() {
        Control control = this.getControl();
        if (control != null && !control.isDisposed()) {
            super.scheduleUpdateJob();
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        for (IPageSection s : this.getSections()) {
            if (!(s instanceof ILaunchConfigurationTabSection)) continue;
            ((ILaunchConfigurationTabSection)s).setDefaults(configuration);
        }
    }

    private Iterable<IPageSection> getSections() {
        if (!this.disposed) {
            if (this.sections == null) {
                this.sections = this.createSections();
            }
            return this.sections;
        }
        return Collections.emptyList();
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        for (IPageSection s : this.getSections()) {
            if (!(s instanceof ILaunchConfigurationTabSection)) continue;
            ((ILaunchConfigurationTabSection)s).initializeFrom(configuration);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        for (IPageSection s : this.getSections()) {
            if (!(s instanceof ILaunchConfigurationTabSection)) continue;
            ((ILaunchConfigurationTabSection)s).performApply(configuration);
        }
        this.setDirty(false);
    }

    public Shell getShell() {
        return super.getShell();
    }

    public void dispose() {
        if (!this.disposed) {
            if (this.sections != null) {
                for (IPageSection s : this.sections) {
                    if (!(s instanceof Disposable)) continue;
                    ((Disposable)s).dispose();
                }
                this.sections = null;
            }
            this.disposed = true;
        }
        super.dispose();
    }

    public IRunnableContext getRunnableContext() {
        return super.getLaunchConfigurationDialog();
    }
}

