/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.launch.livebean;

import java.util.EnumSet;

public class JmxBeanSupport {
    public static final String JMX_PORT_PROP = "com.sun.management.jmxremote.port";
    public static final String LAUNCH_CONFIG_TYPE_ID = "org.springframework.ide.eclipse.boot.launch";

    public static String jmxBeanVmArgs(int jmxPort, EnumSet<Feature> enabled) {
        return JmxBeanSupport.jmxBeanVmArgs("" + jmxPort, enabled);
    }

    public static String jmxBeanVmArgs(String jmxPort, EnumSet<Feature> enabled) {
        if (!enabled.isEmpty()) {
            StringBuilder str = new StringBuilder();
            String[] stringArray = JmxBeanSupport.enableJmxArgs(jmxPort);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String a = stringArray[n2];
                str.append(String.valueOf(a) + "\n");
                ++n2;
            }
            for (Feature feature : enabled) {
                str.append(String.valueOf(feature.vmArg) + "\n");
            }
            return str.toString();
        }
        return "";
    }

    public static String[] enableJmxArgs(String jmxPort) {
        return new String[]{"-Dcom.sun.management.jmxremote", "-Dcom.sun.management.jmxremote.port=" + jmxPort, "-Dcom.sun.management.jmxremote.authenticate=false", "-Dcom.sun.management.jmxremote.ssl=false"};
    }

    public static int randomPort() {
        return (int)(5000.0 + Math.random() * 60000.0);
    }

    public static enum Feature {
        LIVE_BEAN_GRAPH("-Dspring.liveBeansView.mbeanDomain"),
        LIFE_CYCLE("-Dspring.application.admin.enabled=true");

        public final String vmArg;

        private Feature(String vmArg) {
            this.vmArg = vmArg;
        }
    }
}

