/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.content.core;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.osgi.framework.Version;
import org.springsource.ide.eclipse.commons.content.core.util.Descriptor;

public class ContentItem {
    private Descriptor localDescriptor;
    private Descriptor remoteDescriptor;
    private Descriptor defaultDescriptor;
    private final String id;
    private final IProject runtimeProject;

    public ContentItem(String id) {
        this(id, null);
    }

    public ContentItem(String id, IProject runtimeProject) {
        this.id = id;
        this.runtimeProject = runtimeProject;
    }

    public String getDescription() {
        return this.defaultDescriptor != null ? this.defaultDescriptor.getDescription() : null;
    }

    public long getDownloadSize() {
        return this.remoteDescriptor != null ? this.remoteDescriptor.getSize() : 0L;
    }

    public String getId() {
        return this.id;
    }

    public Descriptor getLocalDescriptor() {
        return this.localDescriptor;
    }

    public String getName() {
        return this.defaultDescriptor != null ? this.defaultDescriptor.getName() : null;
    }

    public String getPath() {
        return String.valueOf(this.defaultDescriptor.getId()) + "-" + this.defaultDescriptor.getVersion();
    }

    public String getPathFromRemoteDescriptor() {
        return String.valueOf(this.remoteDescriptor.getId()) + "-" + this.remoteDescriptor.getVersion();
    }

    public Descriptor getRemoteDescriptor() {
        return this.remoteDescriptor;
    }

    public boolean isLocal() {
        return this.localDescriptor != null;
    }

    public boolean isRuntimeDefined() {
        return this.runtimeProject != null;
    }

    public IProject getRuntimeProject() {
        return this.runtimeProject;
    }

    public boolean isNewerVersionAvailable() {
        if (this.localDescriptor != null && this.remoteDescriptor != null) {
            return new Version(this.localDescriptor.getVersion()).compareTo(new Version(this.remoteDescriptor.getVersion())) < 0;
        }
        return false;
    }

    public boolean needsDownload() {
        return !this.isLocal() || this.isNewerVersionAvailable();
    }

    public void setLocalDescriptor(Descriptor localDescriptor) {
        Assert.isNotNull((Object)localDescriptor);
        if (this.shouldReplace(this.localDescriptor, localDescriptor)) {
            this.localDescriptor = localDescriptor;
            this.defaultDescriptor = localDescriptor;
        }
    }

    public void setRemoteDescriptor(Descriptor remoteDescriptor) {
        Assert.isNotNull((Object)remoteDescriptor);
        if (this.shouldReplace(this.remoteDescriptor, remoteDescriptor)) {
            this.remoteDescriptor = remoteDescriptor;
            if (this.defaultDescriptor == null) {
                this.defaultDescriptor = remoteDescriptor;
            }
        }
    }

    private boolean shouldReplace(Descriptor oldDescriptor, Descriptor newDescriptor) {
        Assert.isTrue((boolean)newDescriptor.isValid());
        return oldDescriptor == null || new Version(oldDescriptor.getVersion()).compareTo(new Version(newDescriptor.getVersion())) < 0;
    }

    public String toString() {
        return this.id;
    }
}

