/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jdt.ui.text.java.IQuickFixProcessor;
import org.testng.eclipse.TestNGPlugin;
import org.testng.eclipse.buildpath.BuildPathSupport;
import org.testng.eclipse.ui.TestNGAddLibraryProposal;

public class TestNGQuickFixProcessor
implements IQuickFixProcessor {
    public IJavaCompletionProposal[] getCorrections(IInvocationContext context, IProblemLocation[] locations) throws CoreException {
        IJavaProject project = context.getCompilationUnit().getJavaProject();
        if (!this.isJava5SyntaxSupported(project) || this.isTestNGContainerOnClasspath(project)) {
            return null;
        }
        List res = new ArrayList();
        int i = 0;
        while (i < locations.length) {
            IProblemLocation problem = locations[i];
            int problemId = problem.getProblemId();
            if (this.isImportProblem(problemId)) {
                res = this.getAddTestNGToBuildPathProposals(context, problem, res);
            }
            ++i;
        }
        if (res.isEmpty()) {
            return null;
        }
        return res.toArray(new IJavaCompletionProposal[res.size()]);
    }

    private boolean isImportProblem(int problemId) {
        return problemId == 0x1000002 || problemId == 268435846;
    }

    public boolean hasCorrections(ICompilationUnit unit, int problemId) {
        return this.isImportProblem(problemId);
    }

    private boolean isJava5SyntaxSupported(IJavaProject project) {
        String projectComplianceLevel = TestNGQuickFixProcessor.getSourceCompatabilityLevel(project);
        return "1.5".compareTo(projectComplianceLevel) <= 0;
    }

    private boolean isTestNGContainerOnClasspath(IJavaProject project) {
        try {
            return BuildPathSupport.projectContainsClasspathEntry(project, BuildPathSupport.getTestNGClasspathEntry());
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    private List getAddTestNGToBuildPathProposals(IInvocationContext context, IProblemLocation location, List proposals) {
        try {
            ICompilationUnit compilationUnit = context.getCompilationUnit();
            compilationUnit.getJavaProject();
            String s = compilationUnit.getBuffer().getText(location.getOffset(), location.getLength());
            if (this.maybeTestNGPackage(s)) {
                proposals.add(new TestNGAddLibraryProposal(context, 11));
            }
            if (this.maybeTestNGAnnotation(s) && this.isAnnotation(context)) {
                proposals.add(new TestNGAddLibraryProposal(context, 11, true));
            }
        }
        catch (JavaModelException e) {
            TestNGPlugin.log(e.getStatus());
        }
        return proposals;
    }

    private boolean maybeTestNGPackage(String s) {
        return s.indexOf("org.testng") != -1;
    }

    private boolean maybeTestNGAnnotation(String s) {
        return "Test".equals(s) || "Configuration".equals(s) || "BeforeSuite".equals(s) || "AfterSuite".equals(s) || "BeforeTest".equals(s) || "AfterTest".equals(s) || "BeforeGroups".equals(s) || "AfterGroups".equals(s) || "BeforeClass".equals(s) || "AfterClass".equals(s) || "BeforeMethod".equals(s) || "AfterMethod".equals(s);
    }

    public static String getSourceCompatabilityLevel(IJavaProject project) {
        String complianceLevel = project.getOption("org.eclipse.jdt.core.compiler.source", true);
        return complianceLevel;
    }

    private boolean isAnnotation(IInvocationContext context) {
        return context.getCoveredNode().getParent().getNodeType() == 78;
    }
}

