/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sourceforge.pmd.util.StringUtil;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class ColourManager {
    private final Display display;
    private final Map<RGB, Color> coloursByRGB = new HashMap<RGB, Color>();
    private static ColourManager instance;

    public static ColourManager managerFor(Display display) {
        if (instance == null) {
            instance = new ColourManager(display);
        }
        return instance;
    }

    private ColourManager(Display theDisplay) {
        this.display = theDisplay;
    }

    public Color colourFor(RGB colourFractions) {
        Color colour = this.coloursByRGB.get(colourFractions);
        if (colour != null) {
            return colour;
        }
        colour = new Color((Device)this.display, colourFractions.red, colourFractions.green, colourFractions.blue);
        this.coloursByRGB.put(colourFractions, colour);
        return colour;
    }

    public Color colourFor(String text) {
        if (StringUtil.isEmpty((String)text)) {
            return this.display.getSystemColor(1);
        }
        int length = (text = text.trim()).length();
        if (length < 3) {
            return this.display.getSystemColor(1);
        }
        int posA = length / 3;
        int posB = posA * 2;
        int rHash = text.subSequence(0, posA).hashCode();
        int gHash = text.subSequence(posA, posB).hashCode();
        int bHash = text.subSequence(posB, length).hashCode();
        RGB colourFractions = new RGB((int)(Math.log10(rHash) % 1.0 * 255.0), (int)(Math.log10(gHash) % 1.0 * 255.0), (int)(Math.log10(bHash) % 1.0 * 255.0));
        return this.colourFor(colourFractions);
    }

    public void dispose() {
        Iterator<Color> iter = this.coloursByRGB.values().iterator();
        while (iter.hasNext()) {
            iter.next().dispose();
        }
    }
}

