/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views;

import java.util.List;
import net.sourceforge.pmd.RulePriority;
import net.sourceforge.pmd.eclipse.plugin.UISettings;
import net.sourceforge.pmd.eclipse.ui.model.FileRecord;
import net.sourceforge.pmd.eclipse.ui.views.AbstractPMDPagebookView;
import net.sourceforge.pmd.eclipse.ui.views.PriorityFilter;
import net.sourceforge.pmd.eclipse.ui.views.ViolationOutlinePageBR;
import net.sourceforge.pmd.eclipse.ui.views.actions.DisableRuleAction;
import net.sourceforge.pmd.eclipse.ui.views.actions.PriorityFilterAction;
import net.sourceforge.pmd.eclipse.ui.views.actions.QuickFixAction;
import net.sourceforge.pmd.eclipse.ui.views.actions.RemoveViolationAction;
import net.sourceforge.pmd.eclipse.ui.views.actions.ReviewAction;
import net.sourceforge.pmd.eclipse.ui.views.actions.ShowRuleAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.PageBookView;

public class ViolationOutline
extends AbstractPMDPagebookView
implements ISelectionProvider {
    private FileRecord resourceRecord;
    private PriorityFilter priorityFilter;
    protected static final String PRIORITY_LIST = "priorityFilterList";
    protected static final String COLUMN_WIDTHS = "tableColumnWidths";
    protected static final String COLUMN_SORTER = "tableColumnSorter";

    public void createPartControl(Composite parent) {
        this.addFilterControls();
        super.createPartControl(parent);
        this.getSite().setSelectionProvider((ISelectionProvider)this);
    }

    @Override
    protected String pageMessageId() {
        return "view.outline.default_text";
    }

    @Override
    protected String mementoFileId() {
        return "/violationOutline_memento.xml";
    }

    @Override
    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.priorityFilter = new PriorityFilter();
        List<Integer> priorityList = this.getIntegerList(PRIORITY_LIST);
        if (!priorityList.isEmpty()) {
            this.priorityFilter.setPriorityFilterList(priorityList);
        }
    }

    @Override
    public void dispose() {
        this.save(PRIORITY_LIST, this.priorityFilter.getPriorityFilterList());
        super.dispose();
    }

    protected PageBookView.PageRec doCreatePage(IWorkbenchPart part) {
        if (this.resourceRecord != null) {
            ViolationOutlinePageBR page = new ViolationOutlinePageBR(this.resourceRecord, this);
            this.initPage((IPageBookViewPage)page);
            page.createControl((Composite)this.getPageBook());
            this.loadColumnData(page);
            return new PageBookView.PageRec(part, (IPage)page);
        }
        return null;
    }

    protected void doDestroyPage(IWorkbenchPart part, PageBookView.PageRec pageRecord) {
        ViolationOutlinePageBR page = (ViolationOutlinePageBR)pageRecord.page;
        if (page != null) {
            this.storeColumnData(page);
            this.memento.save();
            page.dispose();
        }
        pageRecord.dispose();
    }

    private void addFilterControls() {
        RulePriority[] priorities;
        IMenuManager manager = this.getViewSite().getActionBars().getMenuManager();
        List<Integer> filterList = this.priorityFilter.getPriorityFilterList();
        RulePriority[] rulePriorityArray = priorities = UISettings.currentPriorities(true);
        int n = priorities.length;
        int n2 = 0;
        while (n2 < n) {
            RulePriority priority = rulePriorityArray[n2];
            PriorityFilterAction filterAction = new PriorityFilterAction(priority, this);
            if (filterList.contains(priority.getPriority())) {
                filterAction.setChecked(true);
            }
            manager.add((IAction)filterAction);
            ++n2;
        }
    }

    public Menu createContextMenu(final TableViewer viewer) {
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ViolationOutline.this.buildMenu(manager, viewer);
            }
        });
        Table table = viewer.getTable();
        return manager.createContextMenu((Control)table);
    }

    private void buildMenu(IMenuManager manager, TableViewer viewer) {
        ShowRuleAction showRuleAction = new ShowRuleAction(viewer, this.getSite().getShell());
        manager.add((IAction)showRuleAction);
        ReviewAction reviewAction = new ReviewAction(viewer);
        manager.add((IAction)reviewAction);
        RemoveViolationAction removeAction = new RemoveViolationAction(viewer);
        manager.add((IAction)removeAction);
        DisableRuleAction disableAction = new DisableRuleAction(viewer);
        disableAction.setEnabled(disableAction.hasActiveRules());
        manager.add((IAction)disableAction);
        QuickFixAction quickFixAction = new QuickFixAction(viewer);
        quickFixAction.setEnabled(quickFixAction.hasQuickFix());
        manager.add((IAction)quickFixAction);
        manager.add((IContributionItem)new Separator("additions"));
        manager.add((IContributionItem)new Separator("additions-end"));
    }

    public void partActivated(IWorkbenchPart part) {
        if (part instanceof IEditorPart) {
            this.resourceRecord = ViolationOutline.tryForFileRecordFrom(part);
        } else {
            IEditorPart editorPart = this.getSitePage().getActiveEditor();
            if (editorPart != null) {
                this.partActivated((IWorkbenchPart)editorPart);
            }
        }
        IWorkbenchPage page = this.getSitePage();
        IWorkbenchPart activePart = page.getActivePart();
        if (activePart == null) {
            page.activate((IWorkbenchPart)this);
        }
        super.partActivated(part);
        this.refresh();
    }

    protected void showPageRec(PageBookView.PageRec pageRec) {
        ViolationOutlinePageBR oldPage = this.getCurrentOutlinePage();
        ViolationOutlinePageBR newPage = null;
        if (pageRec.page instanceof ViolationOutlinePageBR) {
            newPage = (ViolationOutlinePageBR)pageRec.page;
        }
        if (oldPage != newPage) {
            if (oldPage != null) {
                this.storeColumnData(oldPage);
            }
            this.loadColumnData(newPage);
        }
        super.showPageRec(pageRec);
    }

    private void storeColumnData(ViolationOutlinePageBR page) {
        if (page != null) {
            this.save(COLUMN_WIDTHS, page.getColumnWidths());
            this.save(COLUMN_SORTER, page.getSorterProperties());
        }
    }

    private void loadColumnData(ViolationOutlinePageBR page) {
        if (page != null) {
            page.setColumnWidths(this.getIntegerList(COLUMN_WIDTHS));
            page.setSorterProperties(this.getIntegerList(COLUMN_SORTER));
        }
    }

    private ViolationOutlinePageBR getCurrentOutlinePage() {
        IPage page = super.getCurrentPage();
        if (!(page instanceof ViolationOutlinePageBR)) {
            return null;
        }
        return (ViolationOutlinePageBR)page;
    }

    public ViewerFilter[] getFilters() {
        return new ViewerFilter[]{this.priorityFilter};
    }

    public void refresh() {
        ViolationOutlinePageBR page = this.getCurrentOutlinePage();
        if (page != null) {
            page.refresh();
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        ViolationOutlinePageBR page = this.getCurrentOutlinePage();
        if (page != null) {
            page.getTableViewer().addSelectionChangedListener(listener);
        }
    }

    public ISelection getSelection() {
        ViolationOutlinePageBR page = this.getCurrentOutlinePage();
        if (page != null) {
            return page.getTableViewer().getSelection();
        }
        return null;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        ViolationOutlinePageBR page = this.getCurrentOutlinePage();
        if (page != null) {
            page.getTableViewer().removeSelectionChangedListener(listener);
        }
    }

    public void setSelection(ISelection selection) {
        ViolationOutlinePageBR page = this.getCurrentOutlinePage();
        if (page != null) {
            page.getTableViewer().setSelection(selection);
        }
    }
}

