/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansConfig;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansJavaConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.core.io.ExternalFile;
import org.springframework.ide.eclipse.core.java.JdtUtils;

public class BeansConfigFactory {
    public static final String JAVA_CONFIG_TYPE = "java:";

    public static IBeansConfig create(IBeansProject project, String name, IBeansConfig.Type type) {
        return BeansConfigFactory.create(project, name, type, true);
    }

    public static IBeansConfig create(IBeansProject project, String name, IBeansConfig.Type type, boolean removeProjectPrefixFromName) {
        if (name != null && name.startsWith(JAVA_CONFIG_TYPE)) {
            String className = name.substring(JAVA_CONFIG_TYPE.length());
            IJavaProject javaProject = JdtUtils.getJavaProject((IProject)project.getProject());
            try {
                IType configClass = javaProject.findType(className);
                return new BeansJavaConfig(project, configClass, className, IBeansConfig.Type.MANUAL);
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        } else {
            String projectPath;
            if (removeProjectPrefixFromName && name != null && name.length() > 0 && name.charAt(0) == '/' && name.startsWith(projectPath = String.valueOf('/') + project.getElementName() + '/')) {
                name = name.substring(projectPath.length());
            }
            return new BeansConfig(project, name, IBeansConfig.Type.MANUAL);
        }
        return null;
    }

    public static String getConfigName(IFile file, IProject project) {
        IJavaElement element;
        IJavaProject javaProject;
        if (!"xml".equals(file.getFileExtension()) && (javaProject = JdtUtils.getJavaProject((IProject)project.getProject())) != null && (element = JavaCore.create((IResource)file, (IJavaProject)javaProject)) != null && element.getPrimaryElement() instanceof ICompilationUnit) {
            String typeName = element.getElementName();
            String fileExtension = file.getFileExtension();
            if (fileExtension != null && fileExtension.length() > 0) {
                typeName = typeName.substring(0, typeName.length() - (fileExtension.length() + 1));
            }
            IJavaElement parent = element.getParent();
            String packageName = "";
            if (parent.getElementType() == 4) {
                IPackageFragment packageFragment = (IPackageFragment)parent;
                if (!packageFragment.isDefaultPackage()) {
                    packageName = String.valueOf(packageFragment.getElementName()) + ".";
                }
                return JAVA_CONFIG_TYPE + packageName + typeName;
            }
        }
        String configName = file.getProject().equals((Object)project.getProject()) && !(file instanceof ExternalFile) ? file.getProjectRelativePath().toString() : file.getFullPath().toString();
        return configName;
    }

    public static boolean isJavaConfigFile(IFile file) {
        return file != null && (file.getFileExtension().equals("java") || file.getFileExtension().equals("class") || file.getFileExtension().equals("groovy"));
    }
}

