/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.metadata.actions;

import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.debug.ui.actions.ToggleBreakpointAdapter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.springframework.ide.eclipse.metadata.MetadataUIImages;
import org.springframework.ide.eclipse.metadata.actions.Messages;
import org.springframework.ide.eclipse.metadata.core.RequestMappingAnnotationMetadata;
import org.springframework.ide.eclipse.metadata.core.RequestMappingMethodAnnotationMetadata;
import org.springframework.ide.eclipse.metadata.ui.RequestMappingMethodToClassMap;

public class ToggleBreakPointAction
extends BaseSelectionListenerAction {
    private IWorkbenchPart workbenchPart;
    private ToggleBreakpointAdapter breakpointAdapter;

    public ToggleBreakPointAction(IWorkbenchPart workbenchPart) {
        super(Messages.ToggleBreakPointAction_TITLE);
        this.setImageDescriptor(MetadataUIImages.DESC_OBJS_BREAKPOINT);
        this.workbenchPart = workbenchPart;
        this.breakpointAdapter = new ToggleBreakpointAdapter();
    }

    public void run() {
        IStructuredSelection selection = this.getStructuredSelection();
        Object obj = selection.getFirstElement();
        if (obj instanceof RequestMappingAnnotationMetadata) {
            RequestMappingAnnotationMetadata annotation = (RequestMappingAnnotationMetadata)((Object)obj);
            IType type = (IType)JavaCore.create((String)annotation.getClassHandle());
            this.breakpointAdapter.toggleClassBreakpoints(this.workbenchPart, (ISelection)new StructuredSelection((Object)type));
        } else if (obj instanceof RequestMappingMethodToClassMap) {
            RequestMappingMethodAnnotationMetadata annotation = ((RequestMappingMethodToClassMap)obj).getMethodMetadata();
            IMethod method = (IMethod)JavaCore.create((String)annotation.getHandleIdentifier());
            this.breakpointAdapter.toggleMethodBreakpoints(this.workbenchPart, (ISelection)new StructuredSelection((Object)method));
        }
    }
}

