/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.gettingstarted.boot;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.springframework.ide.eclipse.wizard.gettingstarted.boot.MultiSelectionFieldModel;
import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;

public class HierarchicalMultiSelectionFieldModel<T> {
    private Map<String, MultiSelectionFieldModel<T>> categories = new TreeMap<String, MultiSelectionFieldModel<T>>();
    private String name;
    private String label;
    private Class<T> type;

    public HierarchicalMultiSelectionFieldModel(Class<T> type, String name) {
        this.name = name;
        this.label = name;
        this.type = type;
    }

    public Collection<String> getCategories() {
        return Collections.unmodifiableCollection(this.categories.keySet());
    }

    public MultiSelectionFieldModel<T> getContents(String category) {
        return this.categories.get(category);
    }

    public HierarchicalMultiSelectionFieldModel<T> label(String label) {
        this.label = label;
        return this;
    }

    private MultiSelectionFieldModel<T> ensureCategory(String categoryName) {
        MultiSelectionFieldModel<T> existing = this.categories.get(categoryName);
        if (existing == null) {
            existing = new MultiSelectionFieldModel<T>(this.type, this.name).label(categoryName);
            this.categories.put(categoryName, existing);
        }
        return existing;
    }

    public void sort() {
        for (String cat : this.getCategories()) {
            this.getContents(cat).sort();
        }
    }

    public void choice(String catName, String name, T dep, String tooltipText, LiveExpression<Boolean> enablement) {
        MultiSelectionFieldModel<T> cat = this.ensureCategory(catName);
        cat.choice(name, dep, tooltipText, enablement);
    }

    public String getLabel() {
        return this.label;
    }
}

