/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.internal.bestpractices.quickfix;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMarkerResolution2;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.xml.core.internal.document.ElementImpl;
import org.eclipse.wst.xml.core.internal.provisional.format.FormatProcessorXML;
import org.springframework.ide.eclipse.internal.bestpractices.quickfix.XmlQuickFixUtil;
import org.springsource.ide.eclipse.commons.core.StatusHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class CreateReferencedBeanDefinitionMarkerResolution
implements IMarkerResolution2 {
    private static final String MESSAGE_ATTRIBUTE_KEY = "message";
    private String missingBeanId = "";

    public CreateReferencedBeanDefinitionMarkerResolution(IMarker marker) {
        String markerMessage = marker.getAttribute(MESSAGE_ATTRIBUTE_KEY, "");
        this.missingBeanId = this.extractBeanId(markerMessage);
    }

    private String extractBeanId(String message) {
        int startPos = message.indexOf("bean '") + "bean '".length();
        int endPos = message.indexOf("'", startPos);
        return message.substring(startPos, endPos);
    }

    public String getDescription() {
        return "Create bean definition with id " + this.missingBeanId;
    }

    public Image getImage() {
        return null;
    }

    public String getLabel() {
        return "Create bean definition with id " + this.missingBeanId;
    }

    public void run(IMarker marker) {
        IStructuredModel model = null;
        Element beanElement = null;
        try {
            try {
                model = XmlQuickFixUtil.getModel(marker);
                beanElement = XmlQuickFixUtil.getMarkerElement(model, marker);
                if (model != null && beanElement != null) {
                    Document document = beanElement.getOwnerDocument();
                    Element newBeanElement = document.createElement("bean");
                    beanElement.getParentNode().insertBefore(newBeanElement, beanElement.getNextSibling());
                    newBeanElement.setAttribute("id", this.missingBeanId);
                    newBeanElement.setAttribute("class", "");
                    Text spacerNode = document.createTextNode("\n\n");
                    beanElement.getParentNode().insertBefore(spacerNode, newBeanElement);
                    FormatProcessorXML formatProcessor = new FormatProcessorXML();
                    formatProcessor.formatNode((Node)newBeanElement);
                    XmlQuickFixUtil.saveMarkedFile(marker);
                    IEditorPart editor = XmlQuickFixUtil.getMarkedEditor(marker);
                    this.setCursorPositionToClassAttribute((MultiPageEditorPart)editor, (ElementImpl)newBeanElement);
                }
            }
            catch (CoreException e) {
                StatusHandler.log((IStatus)e.getStatus());
                if (model != null) {
                    model.releaseFromEdit();
                }
            }
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }

    private void setCursorPositionToClassAttribute(MultiPageEditorPart xmlEditor, ElementImpl newBeanElement) {
        IEditorPart[] editorParts;
        IEditorPart[] iEditorPartArray = editorParts = xmlEditor.findEditors(xmlEditor.getEditorInput());
        int n = editorParts.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorPart currEditorPart = iEditorPartArray[n2];
            if (currEditorPart instanceof StructuredTextEditor) {
                String classAttributeStartString;
                StructuredTextEditor structuredTextEditor = (StructuredTextEditor)currEditorPart;
                int beanElementStartOffset = newBeanElement.getStartOffset();
                String newBeanTextContent = newBeanElement.getFirstStructuredDocumentRegion().getFullText();
                int classAttributeStartIndex = newBeanTextContent.indexOf(classAttributeStartString = "class=\"") + classAttributeStartString.length();
                if (classAttributeStartIndex > 0) {
                    int documentOffset = beanElementStartOffset + classAttributeStartIndex;
                    structuredTextEditor.selectAndReveal(documentOffset, 0);
                    currEditorPart.setFocus();
                }
            }
            ++n2;
        }
    }
}

