/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.springframework.ide.eclipse.boot.core.BootActivator;
import org.springframework.ide.eclipse.boot.properties.editor.util.ArrayUtils;
import org.springframework.ide.eclipse.boot.properties.editor.util.TypeParser;
import org.springframework.ide.eclipse.boot.util.StringUtil;

public class Type {
    private final String erasure;
    private final Type[] params;
    private static final Map<String, Type> TYPE_FROM_SIG = new HashMap<String, Type>();

    static {
        Type.sig2type("B", Byte.class);
        Type.sig2type("C", Character.class);
        Type.sig2type("D", Double.class);
        Type.sig2type("F", Float.class);
        Type.sig2type("I", Integer.class);
        Type.sig2type("J", Long.class);
        Type.sig2type("S", Short.class);
        Type.sig2type("V", Void.class);
        Type.sig2type("Z", Boolean.class);
    }

    public Type(String erasure, Type[] params) {
        this.erasure = erasure;
        this.params = params;
    }

    public boolean isGeneric() {
        return this.params != null;
    }

    public String getErasure() {
        return this.erasure;
    }

    public Type[] getParams() {
        return this.params;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        this.toString(buf);
        return buf.toString();
    }

    private void toString(StringBuilder buf) {
        buf.append(this.getErasure());
        if (this.isGeneric()) {
            buf.append("<");
            boolean first = true;
            Type[] typeArray = this.getParams();
            int n = typeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Type param = typeArray[n2];
                if (!first) {
                    buf.append(",");
                }
                param.toString(buf);
                first = false;
                ++n2;
            }
            buf.append(">");
        }
    }

    public static Type fromSignature(String typeSig, IType context) {
        Type type = TYPE_FROM_SIG.get(typeSig);
        if (type != null) {
            return type;
        }
        int kind = Signature.getTypeSignatureKind((String)typeSig);
        if (kind == 1) {
            boolean shouldResolve = typeSig.charAt(0) == 'Q';
            String erasure = Signature.getTypeErasure((String)typeSig);
            String pkg = Signature.getSignatureQualifier((String)erasure);
            String nam = Signature.getSignatureSimpleName((String)erasure);
            String[] params = Signature.getTypeParameters((String)typeSig);
            String[] args = Signature.getTypeArguments((String)typeSig);
            if (shouldResolve) {
                erasure = Type.tryToResolve(Type.qualifiedName(pkg, nam), context);
            }
            if (ArrayUtils.hasElements(params)) {
                return null;
            }
            if (ArrayUtils.hasElements(args)) {
                Type[] argTypes = new Type[args.length];
                int i = 0;
                while (i < argTypes.length) {
                    argTypes[i] = Type.fromSignature(args[i], context);
                    ++i;
                }
                return new Type(erasure, argTypes);
            }
            return new Type(erasure, null);
        }
        return null;
    }

    private static String qualifiedName(String pkg, String nam) {
        if (StringUtil.hasText((String)pkg)) {
            return String.valueOf(pkg) + "." + nam;
        }
        return nam;
    }

    private static String tryToResolve(String typeName, IType context) {
        try {
            String[][] resolved = context.resolveType(typeName);
            if (ArrayUtils.hasElements(resolved)) {
                String pkg = resolved[0][0];
                String nam = resolved[0][1];
                if (StringUtil.hasText((String)pkg)) {
                    return String.valueOf(pkg) + "." + nam;
                }
                return nam;
            }
        }
        catch (Exception e) {
            BootActivator.log((Throwable)e);
        }
        return typeName;
    }

    private static void sig2type(String sig, Class<?> cls) {
        TYPE_FROM_SIG.put(sig, TypeParser.parse(cls.getName()));
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.erasure == null ? 0 : this.erasure.hashCode());
        result = 31 * result + Arrays.hashCode(this.params);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Type other = (Type)obj;
        if (this.erasure == null ? other.erasure != null : !this.erasure.equals(other.erasure)) {
            return false;
        }
        return Arrays.equals(this.params, other.params);
    }
}

