/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.handlers.HandlerUtil;
import org.springframework.ide.eclipse.boot.properties.editor.SpringPropertiesEditorPlugin;

public class ContentTypeEnablerDisabler
extends AbstractHandler
implements IExecutableExtension {
    private String contentTypeId = "org.springframework.ide.eclipse.applicationProperties";
    private boolean enable;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IResource rsrc = this.getResource(event);
        if (rsrc != null) {
            this.execute(rsrc);
        }
        return null;
    }

    protected void execute(IResource rsrc) throws ExecutionException {
        try {
            IContentType ctype = Platform.getContentTypeManager().getContentType(this.contentTypeId);
            if (this.enable) {
                ctype.addFileSpec(rsrc.getName(), 4);
            } else {
                ctype.removeFileSpec(rsrc.getName(), 4);
            }
        }
        catch (Exception e) {
            SpringPropertiesEditorPlugin.log(e);
        }
    }

    private IResource getResource(ExecutionEvent event) {
        List<IResource> rs = this.getResources(event);
        if (rs != null && !rs.isEmpty()) {
            return rs.get(0);
        }
        return null;
    }

    private List<IResource> getResources(ExecutionEvent event) {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection != null) {
            ArrayList<IResource> selected = new ArrayList<IResource>();
            if (selection instanceof IStructuredSelection) {
                for (Object obj : (IStructuredSelection)selection) {
                    IResource resource = null;
                    if (obj instanceof IResource) {
                        resource = (IResource)obj;
                    } else if (obj instanceof IAdaptable) {
                        resource = (IResource)((IAdaptable)obj).getAdapter(IResource.class);
                    }
                    if (resource == null) continue;
                    selected.add(resource);
                }
            } else {
                IEditorInput editorInput = HandlerUtil.getActiveEditorInput((ExecutionEvent)event);
                if (editorInput != null && editorInput instanceof IFileEditorInput) {
                    selected.add((IResource)((IFileEditorInput)editorInput).getFile());
                }
            }
            return selected;
        }
        return Collections.emptyList();
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        String[] parts = ((String)data).split(",");
        this.enable = parts[0].equals("enable");
        this.contentTypeId = parts[1];
    }
}

