/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.springframework.ide.eclipse.webflow.core.internal.model.EntryActions;
import org.springframework.ide.eclipse.webflow.core.internal.model.ExitActions;
import org.springframework.ide.eclipse.webflow.core.internal.model.GlobalTransitions;
import org.springframework.ide.eclipse.webflow.core.internal.model.InputMapper;
import org.springframework.ide.eclipse.webflow.core.internal.model.OutputMapper;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowModelXmlUtils;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowState;
import org.springframework.ide.eclipse.webflow.core.model.IActionElement;
import org.springframework.ide.eclipse.webflow.core.model.IAttributeEnabled;
import org.springframework.ide.eclipse.webflow.core.model.ICloneableModelElement;
import org.springframework.ide.eclipse.webflow.core.model.IEntryActions;
import org.springframework.ide.eclipse.webflow.core.model.IExceptionHandler;
import org.springframework.ide.eclipse.webflow.core.model.IExitActions;
import org.springframework.ide.eclipse.webflow.core.model.IGlobalTransitions;
import org.springframework.ide.eclipse.webflow.core.model.IInputAttribute;
import org.springframework.ide.eclipse.webflow.core.model.IInputMapper;
import org.springframework.ide.eclipse.webflow.core.model.IMapping;
import org.springframework.ide.eclipse.webflow.core.model.IOutputAttribute;
import org.springframework.ide.eclipse.webflow.core.model.IOutputMapper;
import org.springframework.ide.eclipse.webflow.core.model.IStateTransition;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowState;
import org.springframework.ide.eclipse.webflow.ui.editor.outline.webflow.WebflowUIImages;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.ActionComposite;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.ExceptionHandlerComposite;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.GlobalTransitionsComposite;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.IDialogValidator;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.ImportComposite;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.InputMapperComposite;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.OutputMapperComposite;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.PropertiesComposite;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.VarComposite;

public class WebflowStatePropertiesDialog
extends TitleAreaDialog
implements IDialogValidator {
    private IWebflowState state;
    private IWebflowState stateClone;
    private Label startStateLabel;
    private Text startStateText;
    private Button okButton;
    private PropertiesComposite properties;
    private ActionComposite entryActionsComposite;
    private ActionComposite exitActionsComposite;
    private ExceptionHandlerComposite exceptionHandlerComposite;
    private OutputMapperComposite outputMapperComposite;
    private InputMapperComposite inputMapperComposite;
    private VarComposite varComposite;
    private ImportComposite importComposite;
    private GlobalTransitionsComposite globalTransitionComposite;
    private List<IActionElement> entryActions;
    private List<IActionElement> exitActions;
    private List<IStateTransition> globalTransitions;
    private List<IOutputAttribute> outputAttributes;
    private List<IMapping> outputMapping;
    private List<IInputAttribute> inputAttributes;
    private List<IMapping> inputMapping;
    private List<IExceptionHandler> exceptionHandler;
    private Label parentLabel;
    private Text parentText;
    private Label abstractLabel;
    private Button abstractText;
    private Label persistenceContextLabel;
    private Button persistenceContextText;

    public WebflowStatePropertiesDialog(Shell parentShell, IWebflowState state) {
        super(parentShell);
        EntryActions entry;
        this.state = state;
        this.stateClone = ((WebflowState)state).cloneModelElement();
        if (this.stateClone.getEntryActions() != null) {
            this.entryActions = new ArrayList<IActionElement>();
            this.entryActions.addAll(this.stateClone.getEntryActions().getEntryActions());
        } else {
            this.entryActions = new ArrayList<IActionElement>();
            entry = new EntryActions();
            entry.createNew((IWebflowModelElement)this.stateClone);
            this.stateClone.setEntryActions((IEntryActions)entry);
        }
        if (this.stateClone.getExitActions() != null) {
            this.exitActions = new ArrayList<IActionElement>();
            this.exitActions.addAll(this.stateClone.getExitActions().getExitActions());
        } else {
            this.exitActions = new ArrayList<IActionElement>();
            ExitActions exit = new ExitActions();
            exit.createNew((IWebflowModelElement)this.stateClone);
            this.stateClone.setExitActions((IExitActions)exit);
        }
        this.outputAttributes = new ArrayList<IOutputAttribute>();
        this.outputMapping = new ArrayList<IMapping>();
        this.inputAttributes = new ArrayList<IInputAttribute>();
        this.inputMapping = new ArrayList<IMapping>();
        if (WebflowModelXmlUtils.isVersion1Flow((IWebflowModelElement)state)) {
            if (this.stateClone.getOutputMapper() != null) {
                this.outputAttributes = new ArrayList<IOutputAttribute>();
                this.outputMapping = new ArrayList<IMapping>();
                this.outputAttributes.addAll(this.stateClone.getOutputMapper().getOutputAttributes());
                this.outputMapping.addAll(this.stateClone.getOutputMapper().getMapping());
            } else {
                this.outputAttributes = new ArrayList<IOutputAttribute>();
                this.outputMapping = new ArrayList<IMapping>();
                entry = new OutputMapper();
                entry.createNew((IWebflowModelElement)this.stateClone);
                this.stateClone.setOutputMapper((IOutputMapper)entry);
            }
        } else {
            this.outputAttributes = new ArrayList<IOutputAttribute>();
            this.outputAttributes.addAll(this.stateClone.getOutputAttributes());
            this.outputMapping = new ArrayList<IMapping>();
            entry = new OutputMapper();
            entry.createNew((IWebflowModelElement)this.stateClone);
            this.stateClone.setOutputMapper((IOutputMapper)entry);
        }
        if (WebflowModelXmlUtils.isVersion1Flow((IWebflowModelElement)state)) {
            if (this.stateClone.getInputMapper() != null) {
                this.inputAttributes = new ArrayList<IInputAttribute>();
                this.inputMapping = new ArrayList<IMapping>();
                this.inputAttributes.addAll(this.stateClone.getInputMapper().getInputAttributes());
                this.inputMapping.addAll(this.stateClone.getInputMapper().getMapping());
            } else {
                this.inputAttributes = new ArrayList<IInputAttribute>();
                this.inputMapping = new ArrayList<IMapping>();
                entry = new InputMapper();
                entry.createNew((IWebflowModelElement)this.stateClone);
                this.stateClone.setInputMapper((IInputMapper)entry);
            }
        } else {
            this.inputAttributes = new ArrayList<IInputAttribute>();
            this.inputAttributes.addAll(this.stateClone.getInputAttributes());
            this.inputMapping = new ArrayList<IMapping>();
            entry = new InputMapper();
            entry.createNew((IWebflowModelElement)this.stateClone);
            this.stateClone.setInputMapper((IInputMapper)entry);
        }
        if (this.stateClone.getGlobalTransitions() != null) {
            this.globalTransitions = new ArrayList<IStateTransition>();
            this.globalTransitions.addAll(this.stateClone.getGlobalTransitions().getGlobalTransitions());
        } else {
            this.globalTransitions = new ArrayList<IStateTransition>();
            entry = new GlobalTransitions();
            entry.createNew((IWebflowModelElement)this.stateClone);
            this.stateClone.setGlobalTransitions((IGlobalTransitions)entry);
        }
        this.exceptionHandler = new ArrayList<IExceptionHandler>();
        if (this.stateClone.getExceptionHandlers() != null) {
            this.exceptionHandler.addAll(this.stateClone.getExceptionHandlers());
        }
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            if (!WebflowModelXmlUtils.isVersion1Flow((IWebflowModelElement)this.state)) {
                this.stateClone.setAbstract(Boolean.toString(this.abstractText.getSelection()));
                this.stateClone.setParent(this.trimString(this.parentText.getText()));
                if (this.persistenceContextText.getSelection()) {
                    this.stateClone.addPersistenceContext();
                } else {
                    this.stateClone.removePersistenceContext();
                }
            }
            if (this.state.getEntryActions() == null && this.entryActions.size() > 0) {
                EntryActions entryActions = new EntryActions();
                entryActions.createNew((IWebflowModelElement)this.stateClone);
                for (IActionElement iActionElement : this.entryActions) {
                    entryActions.addEntryAction(iActionElement);
                }
                this.stateClone.setEntryActions((IEntryActions)entryActions);
            } else if (this.entryActions.size() == 0) {
                this.stateClone.setEntryActions(null);
            } else {
                this.stateClone.getEntryActions().removeAll();
                for (IActionElement iActionElement : this.entryActions) {
                    this.stateClone.getEntryActions().addEntryAction(iActionElement);
                }
            }
            if (this.state.getExitActions() == null && this.exitActions.size() > 0) {
                ExitActions exitActions = new ExitActions();
                exitActions.createNew((IWebflowModelElement)this.stateClone);
                for (IActionElement iActionElement : this.exitActions) {
                    exitActions.addExitAction(iActionElement);
                }
                this.stateClone.setExitActions((IExitActions)exitActions);
            } else if (this.exitActions.size() == 0) {
                this.stateClone.setExitActions(null);
            } else {
                this.stateClone.getExitActions().removeAll();
                for (IActionElement iActionElement : this.exitActions) {
                    this.stateClone.getExitActions().addExitAction(iActionElement);
                }
            }
            if (this.exceptionHandler != null && this.exceptionHandler.size() > 0) {
                this.stateClone.removeAllExceptionHandler();
                for (IExceptionHandler iExceptionHandler : this.exceptionHandler) {
                    this.stateClone.addExceptionHandler(iExceptionHandler);
                }
            } else {
                this.stateClone.removeAllExceptionHandler();
            }
            if (this.state.getOutputMapper() == null && (this.outputAttributes.size() > 0 || this.outputMapping.size() > 0)) {
                if (WebflowModelXmlUtils.isVersion1Flow((IWebflowModelElement)this.state)) {
                    OutputMapper outputMapper = new OutputMapper();
                    outputMapper.createNew((IWebflowModelElement)this.stateClone);
                    for (IInputAttribute iInputAttribute : this.outputAttributes) {
                        outputMapper.addOutputAttribute((IOutputAttribute)iInputAttribute);
                    }
                    for (IMapping iMapping : this.outputMapping) {
                        outputMapper.addMapping(iMapping);
                    }
                    this.stateClone.setOutputMapper((IOutputMapper)outputMapper);
                } else {
                    this.stateClone.removeAllOutputAttribute();
                    for (IInputAttribute iInputAttribute : this.outputAttributes) {
                        this.stateClone.addOutputAttribute((IOutputAttribute)iInputAttribute);
                    }
                    this.stateClone.setOutputMapper(null);
                }
            } else if (this.outputAttributes.size() == 0 && this.outputMapping.size() == 0) {
                this.stateClone.setOutputMapper(null);
            } else {
                this.stateClone.getOutputMapper().removeAllOutputAttribute();
                this.stateClone.getOutputMapper().removeAllMapping();
                for (IInputAttribute iInputAttribute : this.outputAttributes) {
                    this.stateClone.getOutputMapper().addOutputAttribute((IOutputAttribute)iInputAttribute);
                }
                for (IMapping iMapping : this.outputMapping) {
                    this.stateClone.getOutputMapper().addMapping(iMapping);
                }
            }
            if (this.state.getInputMapper() == null && (this.inputAttributes.size() > 0 || this.inputMapping.size() > 0)) {
                if (WebflowModelXmlUtils.isVersion1Flow((IWebflowModelElement)this.state)) {
                    InputMapper inputMapper = new InputMapper();
                    inputMapper.createNew((IWebflowModelElement)this.stateClone);
                    for (IInputAttribute iInputAttribute : this.inputAttributes) {
                        inputMapper.addInputAttribute(iInputAttribute);
                    }
                    for (IMapping iMapping : this.inputMapping) {
                        inputMapper.addMapping(iMapping);
                    }
                    this.stateClone.setInputMapper((IInputMapper)inputMapper);
                } else {
                    this.stateClone.removeAllInputAttribute();
                    for (IInputAttribute iInputAttribute : this.inputAttributes) {
                        this.stateClone.addInputAttribute(iInputAttribute);
                    }
                    this.stateClone.setInputMapper(null);
                }
            } else if (this.inputAttributes.size() == 0 && this.inputMapping.size() == 0) {
                this.stateClone.setInputMapper(null);
            } else {
                this.stateClone.getInputMapper().removeAllInputAttribute();
                this.stateClone.getInputMapper().removeAllMapping();
                for (IInputAttribute iInputAttribute : this.inputAttributes) {
                    this.stateClone.getInputMapper().addInputAttribute(iInputAttribute);
                }
                for (IMapping iMapping : this.inputMapping) {
                    this.stateClone.getInputMapper().addMapping(iMapping);
                }
            }
            if (this.state.getGlobalTransitions() == null && this.globalTransitions.size() > 0) {
                GlobalTransitions globalTransitions = new GlobalTransitions();
                globalTransitions.createNew((IWebflowModelElement)this.stateClone);
                for (IStateTransition iStateTransition : this.globalTransitions) {
                    globalTransitions.addGlobalTransition(iStateTransition);
                }
                this.stateClone.setGlobalTransitions((IGlobalTransitions)globalTransitions);
            } else if (this.globalTransitions.size() == 0) {
                this.stateClone.setGlobalTransitions(null);
            } else {
                this.stateClone.getGlobalTransitions().removeAll();
                for (IStateTransition iStateTransition : this.globalTransitions) {
                    this.stateClone.getGlobalTransitions().addGlobalTransition(iStateTransition);
                }
            }
            ((ICloneableModelElement)this.state).applyCloneValues((IWebflowModelElement)this.stateClone);
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.getShellTitle());
        shell.setImage(this.getImage());
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        if (this.state != null) {
            this.okButton.setEnabled(true);
        } else {
            this.okButton.setEnabled(false);
        }
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle(this.getTitle());
        this.setMessage(this.getMessage());
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(parentComposite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        TabFolder folder = new TabFolder(composite, 0);
        TabItem item1 = new TabItem(folder, 0);
        item1.setText("General");
        item1.setImage(this.getImage());
        TabItem item2 = new TabItem(folder, 0);
        TabItem item3 = new TabItem(folder, 0);
        TabItem item4 = new TabItem(folder, 0);
        TabItem item5 = new TabItem(folder, 0);
        TabItem item6 = new TabItem(folder, 0);
        TabItem item7 = new TabItem(folder, 0);
        TabItem item8 = new TabItem(folder, 0);
        TabItem item9 = new TabItem(folder, 0);
        Group groupActionType = new Group((Composite)folder, 0);
        GridLayout layoutAttMap = new GridLayout();
        layoutAttMap.marginWidth = 3;
        layoutAttMap.marginHeight = 3;
        groupActionType.setLayout((Layout)layoutAttMap);
        groupActionType.setText(" Web Flow ");
        GridData grid = new GridData();
        groupActionType.setLayoutData((Object)grid);
        Composite nameGroup = new Composite((Composite)groupActionType, 0);
        nameGroup.setLayoutData((Object)new GridData(768));
        GridLayout layout1 = new GridLayout();
        layout1.numColumns = 2;
        layout1.marginWidth = 5;
        nameGroup.setLayout((Layout)layout1);
        this.startStateLabel = new Label(nameGroup, 0);
        this.startStateLabel.setText("Start State id");
        this.startStateText = new Text(nameGroup, 2060);
        if (this.state != null && this.state.getStartState() != null && this.state.getStartState().getId() != null) {
            this.startStateText.setText(this.state.getStartState().getId());
        }
        this.startStateText.setLayoutData((Object)new GridData(768));
        if (!WebflowModelXmlUtils.isVersion1Flow((IWebflowModelElement)this.state)) {
            this.parentLabel = new Label(nameGroup, 0);
            this.parentLabel.setText("Parent state id");
            this.parentText = new Text(nameGroup, 2052);
            if (this.state != null && this.state.getParent() != null) {
                this.parentText.setText(this.state.getParent());
            }
            this.parentText.setLayoutData((Object)new GridData(768));
            this.parentText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    WebflowStatePropertiesDialog.this.validateInput();
                }
            });
            this.abstractLabel = new Label(nameGroup, 0);
            this.abstractLabel.setText("Abstract");
            this.abstractText = new Button(nameGroup, 2080);
            if (this.state != null && this.state.getAbstract() != null && this.state.getAbstract().equalsIgnoreCase("true")) {
                this.abstractText.setSelection(true);
            }
            this.abstractText.setLayoutData((Object)new GridData(768));
            this.persistenceContextLabel = new Label(nameGroup, 0);
            this.persistenceContextLabel.setText("Persistence context");
            this.persistenceContextText = new Button(nameGroup, 2080);
            if (this.state != null && this.state.hasPersitenceContext()) {
                this.persistenceContextText.setSelection(true);
            }
            this.persistenceContextText.setLayoutData((Object)new GridData(768));
        }
        item1.setControl((Control)groupActionType);
        item4.setText("Attribute Mapping");
        item4.setImage(WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.attribute_mapper_obj.gif"));
        Composite attributeMapperGroup = new Composite((Composite)folder, 0);
        attributeMapperGroup.setLayoutData((Object)new GridData(1808));
        layout1 = new GridLayout();
        layout1.numColumns = 1;
        layout1.marginWidth = 0;
        layout1.marginHeight = 0;
        attributeMapperGroup.setLayout((Layout)layout1);
        TabFolder folder2 = new TabFolder(attributeMapperGroup, 0);
        folder2.setLayoutData((Object)new GridData(1808));
        TabItem item21 = new TabItem(folder2, 0);
        TabItem item22 = new TabItem(folder2, 0);
        this.inputMapperComposite = new InputMapperComposite(this, item21, this.getShell(), this.inputAttributes, this.inputMapping, this.stateClone.getInputMapper());
        item21.setControl(this.inputMapperComposite.createDialogArea((Composite)folder2));
        this.outputMapperComposite = new OutputMapperComposite(this, item22, this.getShell(), this.outputAttributes, this.outputMapping, this.stateClone.getOutputMapper());
        item22.setControl(this.outputMapperComposite.createDialogArea((Composite)folder2));
        item4.setControl((Control)attributeMapperGroup);
        this.properties = new PropertiesComposite(this, item2, this.getShell(), (IAttributeEnabled)this.stateClone);
        item2.setControl(this.properties.createDialogArea((Composite)folder));
        this.varComposite = new VarComposite(this, item3, this.getShell(), this.stateClone);
        item3.setControl(this.varComposite.createDialogArea((Composite)folder));
        this.entryActionsComposite = new ActionComposite(this, item5, this.getShell(), this.entryActions, (IWebflowModelElement)this.stateClone.getEntryActions(), IActionElement.ACTION_TYPE.ENTRY_ACTION);
        item5.setControl(this.entryActionsComposite.createDialogArea((Composite)folder));
        this.globalTransitionComposite = new GlobalTransitionsComposite(this, item6, this.getShell(), this.globalTransitions, (IWebflowModelElement)this.stateClone.getGlobalTransitions(), this.stateClone);
        item6.setControl(this.globalTransitionComposite.createDialogArea((Composite)folder));
        this.exitActionsComposite = new ActionComposite(this, item7, this.getShell(), this.exitActions, (IWebflowModelElement)this.stateClone.getExitActions(), IActionElement.ACTION_TYPE.EXIT_ACTION);
        item7.setControl(this.exitActionsComposite.createDialogArea((Composite)folder));
        this.exceptionHandlerComposite = new ExceptionHandlerComposite(this, item8, this.getShell(), this.exceptionHandler, (IWebflowModelElement)this.stateClone);
        item8.setControl(this.exceptionHandlerComposite.createDialogArea((Composite)folder));
        this.importComposite = new ImportComposite(this, item9, this.getShell(), this.stateClone);
        item9.setControl(this.importComposite.createDialogArea((Composite)folder));
        WebflowStatePropertiesDialog.applyDialogFont((Control)parentComposite);
        return parentComposite;
    }

    protected Image getImage() {
        return WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.spring_webflow_obj.gif");
    }

    public String getMessage() {
        return "Enter the details for the web flow";
    }

    protected String getShellTitle() {
        return "Flow";
    }

    protected String getTitle() {
        return "Flow properties";
    }

    protected void showError(String error) {
        super.setErrorMessage(error);
    }

    public String trimString(String string) {
        if (string != null && string == "") {
            string = null;
        }
        return string;
    }

    @Override
    public void validateInput() {
        String id = "";
        boolean error = false;
        StringBuffer errorMessage = new StringBuffer();
        if (id == null || "".equals(id)) {
            errorMessage.append("A valid id attribute is required. ");
            error = true;
        }
        if (error) {
            this.getButton(0).setEnabled(false);
            this.setErrorMessage(errorMessage.toString());
        } else {
            this.getButton(0).setEnabled(true);
            this.setErrorMessage(null);
        }
    }
}

