/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.dialogs;

import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.ui.dialogs.FilteredTypesSelectionDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowModelXmlUtils;
import org.springframework.ide.eclipse.webflow.core.model.IVar;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.springframework.ide.eclipse.webflow.ui.editor.outline.webflow.WebflowUIImages;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.DialogUtils;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.IDialogValidator;

public class VarEditorDialog
extends TitleAreaDialog
implements IDialogValidator {
    private IVar property;
    private SelectionListener buttonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            VarEditorDialog.this.handleButtonPressed((Button)e.widget);
        }
    };
    private Label nameLabel;
    private Text nameText;
    private Label scopeLabel;
    private Combo scopeText;
    private Label beanLabel;
    private Text beanText;
    private Label classLabel;
    private Text classText;
    private Button okButton;
    private Button browseTypeButton;
    private Button browseBeanButton;

    public VarEditorDialog(Shell parentShell, IVar state) {
        super(parentShell);
        this.property = state;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            if (WebflowModelXmlUtils.isVersion1Flow((IWebflowModelElement)this.property)) {
                this.property.setScope(this.trimString(this.scopeText.getText()));
                this.property.setBean(this.trimString(this.beanText.getText()));
            }
            this.property.setName(this.trimString(this.nameText.getText()));
            this.property.setClazz(this.trimString(this.classText.getText()));
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.getShellTitle());
        shell.setImage(this.getImage());
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.nameText.setFocus();
        if (this.property != null && this.property.getName() != null) {
            this.okButton.setEnabled(true);
        } else {
            this.okButton.setEnabled(false);
        }
        this.validateInput();
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle(this.getTitle());
        this.setMessage(this.getMessage());
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(parentComposite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Composite nameGroup = new Composite(composite, 0);
        nameGroup.setLayoutData((Object)new GridData(768));
        GridLayout layout1 = new GridLayout();
        layout1.numColumns = 3;
        layout1.marginWidth = 5;
        nameGroup.setLayout((Layout)layout1);
        this.nameLabel = new Label(nameGroup, 0);
        this.nameLabel.setText("Name");
        this.nameText = new Text(nameGroup, 2052);
        if (this.property != null && this.property.getName() != null) {
            this.nameText.setText(this.property.getName());
        }
        this.nameText.setLayoutData((Object)new GridData(768));
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                VarEditorDialog.this.validateInput();
            }
        });
        new Label(nameGroup, 0);
        if (WebflowModelXmlUtils.isVersion1Flow((IWebflowModelElement)this.property)) {
            this.scopeLabel = new Label(nameGroup, 0);
            this.scopeLabel.setText("Scope");
            this.scopeText = new Combo(nameGroup, 12);
            this.scopeText.setItems(new String[]{"", "request", "flash", "flow", "conversation", "default"});
            if (this.property != null && this.property.getScope() != null) {
                this.scopeText.setText(this.property.getScope());
            }
            this.scopeText.setLayoutData((Object)new GridData(768));
            this.scopeText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    VarEditorDialog.this.validateInput();
                }
            });
            new Label(nameGroup, 0);
        }
        this.classLabel = new Label(nameGroup, 0);
        this.classLabel.setText("Class");
        this.classText = new Text(nameGroup, 2052);
        if (this.property != null && this.property.getClazz() != null) {
            this.classText.setText(this.property.getClazz());
        }
        this.classText.setLayoutData((Object)new GridData(768));
        this.classText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                VarEditorDialog.this.validateInput();
            }
        });
        this.browseTypeButton = new Button(nameGroup, 8);
        this.browseTypeButton.setText("...");
        this.browseTypeButton.setLayoutData((Object)new GridData(128));
        this.browseTypeButton.addSelectionListener(this.buttonListener);
        if (WebflowModelXmlUtils.isVersion1Flow((IWebflowModelElement)this.property)) {
            this.beanLabel = new Label(nameGroup, 0);
            this.beanLabel.setText("Bean");
            this.beanText = new Text(nameGroup, 2052);
            if (this.property != null && this.property.getBean() != null) {
                this.beanText.setText(this.property.getBean());
            }
            this.beanText.setLayoutData((Object)new GridData(768));
            this.beanText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    VarEditorDialog.this.validateInput();
                }
            });
            this.browseBeanButton = new Button(nameGroup, 8);
            this.browseBeanButton.setText("...");
            this.browseBeanButton.setLayoutData((Object)new GridData(128));
            this.browseBeanButton.addSelectionListener(this.buttonListener);
        }
        VarEditorDialog.applyDialogFont((Control)parentComposite);
        return parentComposite;
    }

    public String getId() {
        return this.nameText.getText();
    }

    protected Image getImage() {
        return WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.var_obj.gif");
    }

    public String getMessage() {
        return "Enter the details for the variable";
    }

    protected String getShellTitle() {
        return "Variable";
    }

    protected String getTitle() {
        return "Variable properties";
    }

    private void handleButtonPressed(Button button) {
        ElementListSelectionDialog dialog;
        if (button.equals(this.browseTypeButton)) {
            IJavaSearchScope searchScope = SearchEngine.createWorkspaceScope();
            FilteredTypesSelectionDialog dialog2 = new FilteredTypesSelectionDialog(this.getShell(), false, (IRunnableContext)new ProgressMonitorDialog(this.getShell()), searchScope, 5);
            dialog2.setMessage("Select an type");
            dialog2.setBlockOnOpen(true);
            dialog2.setTitle("Type Selection");
            if (dialog2.open() == 0) {
                IType obj = (IType)dialog2.getFirstResult();
                this.classText.setText(obj.getFullyQualifiedName());
            }
        } else if (button.equals(this.browseBeanButton) && (dialog = DialogUtils.openBeanReferenceDialog(this.beanText.getText(), false)).open() == 0) {
            this.beanText.setText(((IBean)dialog.getFirstResult()).getElementName());
        }
        this.validateInput();
    }

    protected void showError(String error) {
        super.setErrorMessage(error);
    }

    public String trimString(String string) {
        if (string != null && string == "") {
            string = null;
        }
        return string;
    }

    @Override
    public void validateInput() {
        String id = this.nameText.getText();
        boolean error = false;
        StringBuffer errorMessage = new StringBuffer();
        if (id == null || "".equals(id)) {
            errorMessage.append("A valid name is required. ");
            error = true;
        }
        if (error) {
            this.getButton(0).setEnabled(false);
            this.setErrorMessage(errorMessage.toString());
        } else {
            this.getButton(0).setEnabled(true);
            this.setErrorMessage(null);
        }
    }
}

