/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.core.config;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.eclipsecs.core.config.CheckstyleConfigurationFile;
import net.sf.eclipsecs.core.config.ICheckConfiguration;
import net.sf.eclipsecs.core.config.ResolvableProperty;
import net.sf.eclipsecs.core.config.configtypes.IConfigurationType;
import net.sf.eclipsecs.core.util.CheckstylePluginException;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class CheckConfiguration
implements ICheckConfiguration {
    private final String mName;
    private final String mLocation;
    private final String mDescription;
    private final IConfigurationType mConfigType;
    private final boolean mIsGlobal;
    private final List<ResolvableProperty> mProperties;
    private Map<String, String> mAdditionalData;
    private CheckstyleConfigurationFile mCheckstyleConfigurationFile;
    private long mExpirationTime = 0L;

    public CheckConfiguration(String name, String location, String description, IConfigurationType type, boolean global, List<ResolvableProperty> properties, Map<String, String> additionalData) {
        this.mName = name;
        this.mLocation = location;
        this.mDescription = description;
        this.mConfigType = type;
        this.mIsGlobal = global;
        this.mAdditionalData = additionalData != null ? Collections.unmodifiableMap(additionalData) : Collections.unmodifiableMap(new HashMap());
        this.mProperties = properties != null ? Collections.unmodifiableList(properties) : Collections.unmodifiableList(new ArrayList());
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public String getLocation() {
        return this.mLocation;
    }

    @Override
    public String getDescription() {
        return this.mDescription;
    }

    @Override
    public IConfigurationType getType() {
        return this.mConfigType;
    }

    @Override
    public Map<String, String> getAdditionalData() {
        return this.mAdditionalData;
    }

    @Override
    public List<ResolvableProperty> getResolvableProperties() {
        return this.mProperties;
    }

    @Override
    public boolean isEditable() {
        return this.mConfigType.isEditable();
    }

    @Override
    public boolean isConfigurable() {
        return this.mConfigType.isConfigurable(this);
    }

    @Override
    public boolean isGlobal() {
        return this.mIsGlobal;
    }

    @Override
    public URL getResolvedConfigurationFileURL() throws CheckstylePluginException {
        return this.getType().getResolvedConfigurationFileURL(this);
    }

    @Override
    public CheckstyleConfigurationFile getCheckstyleConfiguration() throws CheckstylePluginException {
        long currentTime = System.currentTimeMillis();
        if (this.mCheckstyleConfigurationFile == null || currentTime > this.mExpirationTime) {
            this.mCheckstyleConfigurationFile = this.getType().getCheckstyleConfiguration(this);
            this.mExpirationTime = currentTime + 3600000L;
        }
        return this.mCheckstyleConfigurationFile;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ICheckConfiguration)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ICheckConfiguration rhs = (ICheckConfiguration)obj;
        return new EqualsBuilder().append((Object)this.getName(), (Object)rhs.getName()).append((Object)this.getLocation(), (Object)rhs.getLocation()).append((Object)this.getDescription(), (Object)rhs.getDescription()).append((Object)this.getType(), (Object)rhs.getType()).append(this.isGlobal(), rhs.isGlobal()).append(this.getResolvableProperties(), rhs.getResolvableProperties()).append(this.getAdditionalData(), rhs.getAdditionalData()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(928729, 1000003).append((Object)this.getName()).append((Object)this.getLocation()).append((Object)this.getDescription()).append((Object)this.getType()).append(this.isGlobal()).append(this.getResolvableProperties()).append(this.getAdditionalData()).toHashCode();
    }
}

