/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.faces.application.FacesMessage;
import javax.faces.component.MessageFactory;
import javax.faces.component.SelectItemsIterator;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;

public class UISelectOne
extends UIInput {
    public static final String COMPONENT_TYPE = "javax.faces.SelectOne";
    public static final String COMPONENT_FAMILY = "javax.faces.SelectOne";
    public static final String INVALID_MESSAGE_ID = "javax.faces.component.UISelectOne.INVALID";

    public UISelectOne() {
        this.setRendererType("javax.faces.Menu");
    }

    public String getFamily() {
        return "javax.faces.SelectOne";
    }

    protected void validateValue(FacesContext context, Object value) {
        super.validateValue(context, value);
        if (!this.isValid() || value == null) {
            return;
        }
        boolean found = this.matchValue(value, new SelectItemsIterator(this));
        if (!found) {
            FacesMessage message = MessageFactory.getMessage(context, INVALID_MESSAGE_ID);
            message.setSeverity(FacesMessage.SEVERITY_ERROR);
            context.addMessage(this.getClientId(context), message);
            this.setValid(false);
        }
    }

    private boolean matchValue(Object value, Iterator items) {
        while (items.hasNext()) {
            SelectItem item = (SelectItem)items.next();
            if (item instanceof SelectItemGroup) {
                Object[] subitems = ((SelectItemGroup)item).getSelectItems();
                if (subitems == null || subitems.length <= 0 || !this.matchValue(value, new ArrayIterator(subitems))) continue;
                return true;
            }
            if (value == null && item.getValue() == null) {
                return true;
            }
            if (!value.equals(item.getValue())) continue;
            return true;
        }
        return false;
    }

    class ArrayIterator
    implements Iterator {
        private Object[] items;
        private int index = 0;

        public ArrayIterator(Object[] items) {
            this.items = items;
        }

        public boolean hasNext() {
            return this.index < this.items.length;
        }

        public Object next() {
            try {
                return this.items[this.index++];
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

