/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.convert;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.ajax4jsf.Messages;
import org.richfaces.component.UIColorPicker;
import org.richfaces.component.util.MessageUtil;

public class IntegerColorConverter
implements Converter {
    private static final Pattern NUMBER = Pattern.compile("(\\d+)");
    public static final String CONVERTER_ID = "org.richfaces.IntegerColor";

    private int convertToInteger(String colorValue) {
        int result = 0;
        if (colorValue.charAt(0) == '#') {
            result = Integer.parseInt(colorValue.substring(1), 16);
        } else {
            Matcher matcher = NUMBER.matcher(colorValue);
            for (int i = 1; i <= 3; ++i) {
                if (!matcher.find()) {
                    throw new IllegalArgumentException(colorValue);
                }
                if (i != 1) {
                    result <<= 8;
                }
                result |= 0xFF & Short.parseShort(matcher.group(1));
            }
        }
        return result;
    }

    private String convertToString(int value, String colorMode) {
        if ("rgb".equals(colorMode)) {
            StringBuilder sb = new StringBuilder("rgb(");
            sb.append((value & 0xFF0000) >> 16);
            sb.append(", ");
            sb.append((value & 0xFF00) >> 8);
            sb.append(", ");
            sb.append(value & 0xFF);
            sb.append(")");
            return sb.toString();
        }
        StringBuilder sb = new StringBuilder("#");
        String hexString = Integer.toHexString(value);
        for (int i = 0; i < 6 - hexString.length(); ++i) {
            sb.append('0');
        }
        sb.append(hexString);
        return sb.toString();
    }

    public Object getAsObject(FacesContext context, UIComponent component, String value) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (component == null) {
            throw new NullPointerException("component");
        }
        if (value != null && value.length() != 0) {
            try {
                return this.convertToInteger(value);
            }
            catch (Exception e) {
                Object label = MessageUtil.getLabel((FacesContext)context, (UIComponent)component);
                String summary = Messages.getMessage((String)"COMPONENT_CONVERSION_ERROR", (Object)label, (Object)value);
                throw new ConverterException(new FacesMessage(summary), (Throwable)e);
            }
        }
        return null;
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (component == null) {
            throw new NullPointerException("component");
        }
        if (value != null) {
            try {
                return this.convertToString((Integer)value, ((UIColorPicker)component).getColorMode());
            }
            catch (Exception e) {
                Object label = MessageUtil.getLabel((FacesContext)context, (UIComponent)component);
                String summary = Messages.getMessage((String)"COMPONENT_CONVERSION_ERROR", (Object)label, (Object)value);
                throw new ConverterException(new FacesMessage(summary), (Throwable)e);
            }
        }
        return "";
    }
}

