/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.internal.javassist;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.security.ProtectionDomain;
import javassist.bytecode.ClassFile;
import org.hibernate.HibernateException;
import org.hibernate.bytecode.buildtime.spi.ClassFilter;
import org.hibernate.bytecode.internal.javassist.FieldFilter;
import org.hibernate.bytecode.internal.javassist.FieldHandled;
import org.hibernate.bytecode.internal.javassist.FieldTransformer;
import org.hibernate.bytecode.spi.AbstractClassTransformerImpl;
import org.hibernate.internal.CoreMessageLogger;
import org.jboss.logging.Logger;

public class JavassistClassTransformer
extends AbstractClassTransformerImpl {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)JavassistClassTransformer.class.getName());

    public JavassistClassTransformer(ClassFilter classFilter, org.hibernate.bytecode.buildtime.spi.FieldFilter fieldFilter) {
        super(classFilter, fieldFilter);
    }

    @Override
    protected byte[] doTransform(ClassLoader loader, String className, Class classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        ClassFile classfile;
        try {
            classfile = new ClassFile(new DataInputStream(new ByteArrayInputStream(classfileBuffer)));
        }
        catch (IOException e) {
            LOG.unableToBuildEnhancementMetamodel(className);
            return classfileBuffer;
        }
        FieldTransformer transformer = this.getFieldTransformer(classfile);
        if (transformer != null) {
            LOG.debugf("Enhancing %s", className);
            FilterOutputStream out = null;
            try {
                transformer.transform(classfile);
                ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
                out = new DataOutputStream(byteStream);
                classfile.write((DataOutputStream)out);
                byte[] byArray = byteStream.toByteArray();
                return byArray;
            }
            catch (Exception e) {
                LOG.unableToTransformClass(e.getMessage());
                throw new HibernateException("Unable to transform class: " + e.getMessage());
            }
            finally {
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException e) {}
            }
        }
        return classfileBuffer;
    }

    protected FieldTransformer getFieldTransformer(final ClassFile classfile) {
        if (this.alreadyInstrumented(classfile)) {
            return null;
        }
        return new FieldTransformer(new FieldFilter(){

            @Override
            public boolean handleRead(String desc, String name) {
                return JavassistClassTransformer.this.fieldFilter.shouldInstrumentField(classfile.getName(), name);
            }

            @Override
            public boolean handleWrite(String desc, String name) {
                return JavassistClassTransformer.this.fieldFilter.shouldInstrumentField(classfile.getName(), name);
            }

            @Override
            public boolean handleReadAccess(String fieldOwnerClassName, String fieldName) {
                return JavassistClassTransformer.this.fieldFilter.shouldTransformFieldAccess(classfile.getName(), fieldOwnerClassName, fieldName);
            }

            @Override
            public boolean handleWriteAccess(String fieldOwnerClassName, String fieldName) {
                return JavassistClassTransformer.this.fieldFilter.shouldTransformFieldAccess(classfile.getName(), fieldOwnerClassName, fieldName);
            }
        });
    }

    private boolean alreadyInstrumented(ClassFile classfile) {
        String[] intfs = classfile.getInterfaces();
        for (int i = 0; i < intfs.length; ++i) {
            if (!FieldHandled.class.getName().equals(intfs[i])) continue;
            return true;
        }
        return false;
    }
}

