/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.template;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.springframework.ide.eclipse.wizard.WizardPlugin;
import org.springsource.ide.eclipse.commons.content.core.ContentLocation;
import org.springsource.ide.eclipse.commons.content.core.ContentPlugin;

public class BundleTemplateLocation
implements ContentLocation {
    public static final String DESCRIPTOR_LOCATION = "/template/descriptor.xml";

    public InputStream streamFromContentLocation(String relativeURL) throws CoreException {
        try {
            String relativePath = this.getRelativeFilePath(relativeURL);
            if (relativePath != null) {
                Path path = new Path(relativePath);
                return FileLocator.openStream((Bundle)this.getBundle(), (IPath)path, (boolean)false);
            }
        }
        catch (IOException e) {
            String message = NLS.bind((String)"Unable to find resource {0} in bundle {1}", (Object)relativeURL, (Object)this.getBundle().getLocation());
            throw new CoreException((IStatus)new Status(4, "org.springsource.ide.eclipse.commons.content.core", message, (Throwable)e));
        }
        return null;
    }

    protected String getRelativeFilePath(String location) throws CoreException {
        try {
            URI uri = new URI(location);
            if (uri.getScheme() == null || uri.getScheme().startsWith("file")) {
                return uri.getPath();
            }
        }
        catch (URISyntaxException e) {
            throw new CoreException((IStatus)new Status(4, "org.springsource.ide.eclipse.commons.content.core", "Failed to load descriptors from location due to malformed URI: " + location, (Throwable)e));
        }
        return null;
    }

    public File getContentLocationFile() {
        URL url = FileLocator.find((Bundle)this.getBundle(), (IPath)new Path(DESCRIPTOR_LOCATION), null);
        if (url != null) {
            try {
                url = FileLocator.toFileURL((URL)url);
                return new File(url.getPath());
            }
            catch (IOException e) {
                ContentPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.springsource.ide.eclipse.commons.content.core", "Failed to load descriptors from location due to I/O exception: /template/descriptor.xml", (Throwable)e));
            }
        }
        return null;
    }

    protected Bundle getBundle() {
        return WizardPlugin.getDefault().getBundle();
    }

    public String getContentLocation() {
        return DESCRIPTOR_LOCATION;
    }
}

