/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.editor.contentassist.bean;

import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.swt.graphics.Image;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IContentAssistCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IContentAssistContext;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IContentAssistProposalRecorder;
import org.springframework.ide.eclipse.beans.ui.editor.util.BeansEditorUtils;
import org.springframework.ide.eclipse.core.java.Introspector;
import org.springframework.ide.eclipse.core.java.JdtUtils;

public class PropertyNameContentAssistCalculator
implements IContentAssistCalculator {
    public static final int PROPERTY_RELEVANCE = 10;
    private JavaElementImageProvider imageProvider = new JavaElementImageProvider();

    @Override
    public void computeProposals(IContentAssistContext context, IContentAssistProposalRecorder recorder) {
        if (context.getParentNode() != null && "bean".equals(context.getParentNode().getLocalName())) {
            IType type;
            IFile file = context.getFile();
            String className = BeansEditorUtils.getClassNameForBean(file, context.getDocument(), context.getParentNode());
            if (file != null && file.exists() && (type = JdtUtils.getJavaType((IProject)file.getProject(), (String)className)) != null) {
                this.addPropertyNameAttributeValueProposals(recorder, context.getMatchString(), "", type);
            }
        }
    }

    protected void addPropertyNameAttributeValueProposals(IContentAssistProposalRecorder recorder, String prefix, String oldPrefix, IType type) {
        if (prefix.lastIndexOf(".") >= 0) {
            int firstIndex = prefix.indexOf(".");
            String firstPrefix = prefix.substring(0, firstIndex);
            String lastPrefix = prefix.substring(firstIndex);
            if (".".equals(lastPrefix)) {
                lastPrefix = "";
            } else if (lastPrefix.startsWith(".")) {
                lastPrefix = lastPrefix.substring(1);
            }
            try {
                Iterator iterator;
                Set methods = Introspector.findReadableProperties((IType)type, (String)firstPrefix, (boolean)true);
                if (methods != null && methods.size() == 1 && (iterator = methods.iterator()).hasNext()) {
                    IMethod method = (IMethod)iterator.next();
                    IType returnType = JdtUtils.getJavaTypeForMethodReturnType((IMethod)method, (IType)type);
                    if (returnType != null) {
                        String newPrefix = String.valueOf(oldPrefix) + firstPrefix + ".";
                        this.addPropertyNameAttributeValueProposals(recorder, lastPrefix, newPrefix, returnType);
                    }
                    return;
                }
            }
            catch (CoreException coreException) {}
        } else {
            try {
                Set methods = Introspector.findWritableProperties((IType)type, (String)prefix, (boolean)true);
                if (methods != null && methods.size() > 0) {
                    Iterator iterator = methods.iterator();
                    while (iterator.hasNext()) {
                        this.createMethodProposal(recorder, (IMethod)iterator.next(), oldPrefix);
                    }
                }
            }
            catch (JavaModelException javaModelException) {}
        }
    }

    protected void createMethodProposal(IContentAssistProposalRecorder recorder, IMethod method, String prefix) {
        try {
            String[] parameterNames = method.getParameterNames();
            String[] parameterTypes = JdtUtils.getParameterTypesString((IMethod)method);
            String propertyName = JdtUtils.getPropertyNameFromMethodName((IMethod)method);
            String methodParentName = JdtUtils.getParentName((IMethod)method);
            String methodName = JdtUtils.getMethodName((IMethod)method);
            String replaceText = String.valueOf(prefix) + propertyName;
            StringBuilder buf = new StringBuilder();
            buf.append(propertyName);
            buf.append(" - ");
            buf.append(methodParentName);
            buf.append('.');
            buf.append(methodName);
            buf.append('(');
            if (parameterTypes != null && parameterNames != null && parameterTypes.length > 0 && parameterNames.length > 0) {
                buf.append(parameterTypes[0]);
                buf.append(' ');
                buf.append(parameterNames[0]);
            }
            buf.append(')');
            String displayText = buf.toString();
            Image image = this.imageProvider.getImageLabel((Object)method, method.getFlags() | 2);
            recorder.recordProposal(image, 10, displayText, replaceText, method);
        }
        catch (JavaModelException javaModelException) {}
    }
}

