/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.StringLiteral;

public class DependencyVisitor
extends ASTVisitor {
    private static final String ANNOTATION_PACKAGE = "org.testng.annotations.";
    private static final String TEST_ANNOTATION = "Test";
    private static final String TEST_ANNOTATION_FQN = "org.testng.annotations.Test";
    private static final String DEPENDS_ON_METHODS = "dependsOnMethods";
    private static final String DEPENDS_ON_GROUPS = "dependsOnGroups";
    List<String> m_dependsOnMethods = Lists.newArrayList();
    List<String> m_dependsOnGroups = Lists.newArrayList();

    public boolean visit(NormalAnnotation annotation) {
        String typeName = annotation.getTypeName().getFullyQualifiedName();
        if (!TEST_ANNOTATION.equals(typeName) && !TEST_ANNOTATION_FQN.equals(typeName)) {
            return false;
        }
        List values = annotation.values();
        if (values != null && !values.isEmpty()) {
            int i = 0;
            while (i < values.size()) {
                MemberValuePair pair = (MemberValuePair)values.get(i);
                String name = pair.getName().toString();
                if (DEPENDS_ON_METHODS.equals(name)) {
                    this.m_dependsOnMethods.addAll(this.extractValues(pair.getValue()));
                } else if (DEPENDS_ON_GROUPS.equals(name)) {
                    this.m_dependsOnGroups.addAll(this.extractValues(pair.getValue()));
                }
                ++i;
            }
        }
        return false;
    }

    public List<String> getDependsOnGroups() {
        return this.m_dependsOnGroups;
    }

    public List<String> getDependsOnMethods() {
        return this.m_dependsOnMethods;
    }

    private List<String> extractValues(Expression paramAttr) {
        ArrayList values = Lists.newArrayList();
        if (paramAttr instanceof ArrayInitializer) {
            List literals = ((ArrayInitializer)paramAttr).expressions();
            int j = 0;
            while (j < literals.size()) {
                StringLiteral str = (StringLiteral)literals.get(j);
                values.add(str.getLiteralValue());
                ++j;
            }
        } else if (paramAttr instanceof StringLiteral) {
            values.add(((StringLiteral)paramAttr).getLiteralValue());
        }
        return values;
    }
}

