/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.commands;

import java.io.File;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.client.OperationManager;
import org.tigris.subversion.subclipse.core.client.OperationResourceCollector;
import org.tigris.subversion.subclipse.core.commands.ISVNCommand;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNNotifyListener;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public class UnlockResourcesCommand
implements ISVNCommand {
    private IResource[] resources;
    private boolean force;
    private SVNWorkspaceRoot root;
    private OperationResourceCollector operationResourceCollector = new OperationResourceCollector();

    public UnlockResourcesCommand(SVNWorkspaceRoot root, IResource[] resources, boolean force) {
        this.resources = resources;
        this.force = force;
        this.root = root;
    }

    public void run(IProgressMonitor monitor) throws SVNException {
        ISVNClientAdapter svnClient = this.root.getRepository().getSVNClient();
        File[] resourceFiles = new File[this.resources.length];
        int i = 0;
        while (i < this.resources.length) {
            resourceFiles[i] = this.resources[i].getLocation().toFile();
            ++i;
        }
        try {
            try {
                monitor.beginTask(null, 100);
                svnClient.addNotifyListener((ISVNNotifyListener)this.operationResourceCollector);
                OperationManager.getInstance().beginOperation(svnClient);
                svnClient.unlock(resourceFiles, this.force);
            }
            catch (SVNClientException e) {
                throw SVNException.wrapException((Exception)((Object)e));
            }
        }
        finally {
            Set<IResource> operationResources = this.operationResourceCollector.getOperationResources();
            OperationManager.getInstance().endOperation(true, operationResources);
            svnClient.removeNotifyListener((ISVNNotifyListener)this.operationResourceCollector);
            this.root.getRepository().returnSVNClient(svnClient);
            monitor.done();
        }
    }
}

