/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.springframework.ide.eclipse.boot.properties.editor.SpringPropertiesEditorPlugin;
import org.springframework.ide.eclipse.boot.properties.editor.util.FuzzyMatcher;
import org.springframework.ide.eclipse.boot.util.StringUtil;

public abstract class FuzzyMap<E>
implements Iterable<E> {
    private TreeMap<String, E> entries = new TreeMap();

    @Override
    public Iterator<E> iterator() {
        return this.entries.values().iterator();
    }

    protected abstract String getKey(E var1);

    public void add(E value) {
        String key = this.getKey(value);
        E existing = this.entries.get(key);
        if (existing == null) {
            this.entries.put(this.getKey(value), value);
        } else {
            SpringPropertiesEditorPlugin.warning(String.valueOf(FuzzyMap.class.getName()) + ": Multiple entries for key " + key + " some entries discarded");
        }
    }

    public List<Match<E>> find(String pattern) {
        if ("".equals(pattern)) {
            ArrayList<Match<Match<E>>> matches = new ArrayList<Match<Match<E>>>(this.entries.size());
            for (E v : this.entries.values()) {
                matches.add(new Match<E>(pattern, 1.0, v));
            }
            return matches;
        }
        ArrayList<Match<Match<E>>> matches = new ArrayList<Match<Match<E>>>();
        for (Map.Entry<String, E> e : this.entries.entrySet()) {
            String key = e.getKey();
            double score = FuzzyMatcher.matchScore(pattern, key);
            if (score == 0.0) continue;
            matches.add(new Match<E>(pattern, score, e.getValue()));
        }
        return matches;
    }

    public String findValidPrefix(String propertyName) {
        E best = this.findLongestCommonPrefixEntry(propertyName);
        return best == null ? null : StringUtil.commonPrefix((String)propertyName, (String)this.getKey(best));
    }

    public E findLongestCommonPrefixEntry(String propertyName) {
        Map.Entry<String, E> best;
        Map.Entry<String, E> ceiln = this.entries.ceilingEntry(propertyName);
        Map.Entry<String, E> floor = this.entries.floorEntry(propertyName);
        if (floor == null || floor == ceiln) {
            best = ceiln;
        } else if (ceiln == null) {
            best = floor;
        } else {
            int floorScore = floor == null ? 0 : StringUtil.commonPrefixLength((String)floor.getKey(), (String)propertyName);
            int ceilnScore = ceiln == null ? 0 : StringUtil.commonPrefixLength((String)ceiln.getKey(), (String)propertyName);
            best = floorScore > ceilnScore ? floor : ceiln;
        }
        return best == null ? null : (E)best.getValue();
    }

    public E get(String id) {
        return this.entries.get(id);
    }

    public boolean isEmpty() {
        return this.entries == null || this.entries.isEmpty();
    }

    public int size() {
        return this.entries.size();
    }

    public static class Match<E> {
        public double score;
        public final E data;
        private String pattern;

        public Match(String pattern, double score, E e) {
            this.pattern = pattern;
            this.score = score;
            this.data = e;
        }

        public static <E> Match<E> getBest(Collection<Match<E>> matches) {
            double bestScore = Double.NEGATIVE_INFINITY;
            Match<E> best = null;
            for (Match<E> match : matches) {
                if (!(match.score > bestScore)) continue;
                best = match;
                bestScore = match.score;
            }
            return best;
        }

        public String toString() {
            return "Match(score=" + this.score + ", data=" + this.data + ")";
        }

        public String getPattern() {
            return this.pattern;
        }
    }
}

