/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.data.metadata.ui;

import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.metadata.model.IBeanMetadata;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.core.model.IModelSourceLocation;
import org.springframework.ide.eclipse.data.SpringDataUtils;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class RepositoriesBeanMetadata
implements IBeanMetadata {
    private static final long serialVersionUID = 5730990435174474138L;
    private final String beanId;
    private final IModelSourceLocation location;

    public RepositoriesBeanMetadata(IBean bean, IModelSourceLocation location) {
        Assert.notNull((Object)location);
        Assert.notNull((Object)bean);
        Assert.isTrue((boolean)SpringDataUtils.isRepositoryBean(bean));
        this.beanId = bean.getElementID();
        this.location = location;
    }

    public String getValueAsText() {
        return SpringDataUtils.asText(this.getValue());
    }

    public String getHandleIdentifier() {
        return this.beanId;
    }

    public String getKey() {
        return "Spring Data Repositories";
    }

    public IBean getValue() {
        return (IBean)BeansCorePlugin.getModel().getElement(this.beanId);
    }

    public IModelSourceLocation getElementSourceLocation() {
        return this.location;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RepositoriesBeanMetadata that = (RepositoriesBeanMetadata)obj;
        return ObjectUtils.nullSafeEquals((Object)this.beanId, (Object)that.beanId) && ObjectUtils.nullSafeEquals((Object)this.location, (Object)that.location);
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode((Object)this.beanId) + ObjectUtils.nullSafeHashCode((Object)this.location);
    }
}

