/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model.namespaces;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.osgi.framework.Bundle;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.internal.model.namespaces.NamespaceDefinition;
import org.springframework.ide.eclipse.beans.core.internal.model.namespaces.NamespacePlugins;
import org.springframework.ide.eclipse.beans.core.internal.model.namespaces.TargetNamespaceScanner;
import org.springframework.ide.eclipse.beans.core.model.INamespaceDefinition;
import org.springframework.ide.eclipse.beans.core.model.INamespaceDefinitionListener;
import org.springframework.ide.eclipse.beans.core.model.INamespaceDefinitionResolver;
import org.springframework.util.StringUtils;

public class ToolingAwareNamespacePlugins
extends NamespacePlugins
implements INamespaceDefinitionResolver {
    private static final String META_INF = "META-INF/";
    private static final String SPRING_SCHEMAS = "spring.schemas";
    private static final String SPRING_TOOLING = "spring.tooling";
    private volatile Map<String, NamespaceDefinition> namespaceDefinitionRegistry = new HashMap<String, NamespaceDefinition>();
    private volatile Map<Bundle, Set<NamespaceDefinition>> namespaceDefinitionsByBundle = new HashMap<Bundle, Set<NamespaceDefinition>>();
    private volatile Set<INamespaceDefinitionListener> namespaceDefinitionListeners = Collections.synchronizedSet(new HashSet());

    @Override
    void addPlugin(Bundle bundle, boolean lazyBundle, boolean applyCondition) {
        super.addPlugin(bundle, lazyBundle, applyCondition);
        this.addNamespaceDefinition(bundle);
    }

    @Override
    boolean removePlugin(Bundle bundle) {
        this.removeNamespaceDefinition(bundle);
        return super.removePlugin(bundle);
    }

    @Override
    public Set<INamespaceDefinition> getNamespaceDefinitions() {
        return new HashSet<INamespaceDefinition>(this.namespaceDefinitionRegistry.values());
    }

    @Override
    public INamespaceDefinition resolveNamespaceDefinition(String namespaceUri) {
        return this.namespaceDefinitionRegistry.get(namespaceUri);
    }

    private void addNamespaceDefinition(Bundle bundle) {
        HashSet<NamespaceDefinition> namespaceDefinitions = new HashSet<NamespaceDefinition>();
        this.namespaceDefinitionsByBundle.put(bundle, namespaceDefinitions);
        Enumeration schemas = bundle.findEntries(META_INF, SPRING_SCHEMAS, false);
        if (schemas != null) {
            while (schemas.hasMoreElements()) {
                Properties props = this.loadProperties((URL)schemas.nextElement());
                for (Object xsd : props.keySet()) {
                    String key = xsd.toString();
                    String namespaceUri = TargetNamespaceScanner.getTargetNamespace(bundle.getEntry(props.getProperty(key)));
                    String icon = null;
                    String prefix = null;
                    String name = null;
                    if (!StringUtils.hasText((String)namespaceUri)) continue;
                    Enumeration tooling = bundle.findEntries(META_INF, SPRING_TOOLING, false);
                    if (tooling != null) {
                        while (tooling.hasMoreElements()) {
                            Properties toolingProps = this.loadProperties((URL)tooling.nextElement());
                            icon = toolingProps.getProperty(String.valueOf(namespaceUri) + "@icon");
                            prefix = toolingProps.getProperty(String.valueOf(namespaceUri) + "@prefix");
                            name = toolingProps.getProperty(String.valueOf(namespaceUri) + "@name");
                        }
                    }
                    if (this.namespaceDefinitionRegistry.containsKey(namespaceUri)) {
                        this.namespaceDefinitionRegistry.get(namespaceUri).addSchemaLocation(key);
                        this.namespaceDefinitionRegistry.get(namespaceUri).addUri(props.getProperty(key));
                        continue;
                    }
                    NamespaceDefinition namespaceDefinition = new NamespaceDefinition(props);
                    namespaceDefinition.setName(name);
                    namespaceDefinition.setPrefix(prefix);
                    namespaceDefinition.setIconPath(icon);
                    namespaceDefinition.addSchemaLocation(key);
                    namespaceDefinition.setBundle(bundle);
                    namespaceDefinition.setNamespaceUri(namespaceUri);
                    namespaceDefinition.addUri(props.getProperty(key));
                    this.registerNamespaceDefinition(namespaceUri, namespaceDefinition);
                    namespaceDefinitions.add(namespaceDefinition);
                }
            }
        }
    }

    private void registerNamespaceDefinition(String uri, final NamespaceDefinition definition) {
        this.namespaceDefinitionRegistry.put(uri, definition);
        for (final INamespaceDefinitionListener listener : this.namespaceDefinitionListeners) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    listener.onNamespaceDefinitionRegistered(new INamespaceDefinitionListener.NamespaceDefinitionChangeEvent(definition, null));
                }

                public void handleException(Throwable exception) {
                    BeansCorePlugin.log(exception);
                }
            });
        }
    }

    private Properties loadProperties(URL url) {
        Properties toolingProps = new Properties();
        try {
            toolingProps.load(url.openStream());
        }
        catch (IOException e) {
            BeansCorePlugin.log(e);
        }
        return toolingProps;
    }

    private void removeNamespaceDefinition(Bundle bundle) {
        if (this.namespaceDefinitionsByBundle.containsKey(bundle)) {
            for (NamespaceDefinition definition : this.namespaceDefinitionsByBundle.get(bundle)) {
                this.unregisterNamespaceDefinition(definition);
            }
            this.namespaceDefinitionsByBundle.remove(bundle);
        }
    }

    private void unregisterNamespaceDefinition(final NamespaceDefinition definition) {
        this.namespaceDefinitionRegistry.remove(definition.getNamespaceUri());
        for (final INamespaceDefinitionListener listener : this.namespaceDefinitionListeners) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    listener.onNamespaceDefinitionUnregistered(new INamespaceDefinitionListener.NamespaceDefinitionChangeEvent(definition, null));
                }

                public void handleException(Throwable exception) {
                    BeansCorePlugin.log(exception);
                }
            });
        }
    }

    public void unregisterNamespaceDefinitionListener(INamespaceDefinitionListener listener) {
        this.namespaceDefinitionListeners.remove(listener);
    }

    public void registerNamespaceDefinitionListener(INamespaceDefinitionListener listener) {
        if (!this.namespaceDefinitionListeners.contains(listener)) {
            this.namespaceDefinitionListeners.add(listener);
        }
    }

    static class Version
    implements Comparable<Version> {
        private static final String MINIMUM_VERSION_STRING = "0";
        public static final Version MINIMUM_VERSION = new Version("0");
        private final org.osgi.framework.Version version;

        public Version(String v) {
            org.osgi.framework.Version tempVersion = null;
            try {
                tempVersion = org.osgi.framework.Version.parseVersion((String)v);
            }
            catch (Exception e) {
                BeansCorePlugin.log("Cannot convert schema vesion", e);
                tempVersion = org.osgi.framework.Version.parseVersion((String)MINIMUM_VERSION_STRING);
            }
            this.version = tempVersion;
        }

        @Override
        public int compareTo(Version v2) {
            return this.version.compareTo(v2.version);
        }
    }
}

