/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.RulePriority;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.plugin.UISettings;
import net.sourceforge.pmd.eclipse.ui.model.AbstractPMDRecord;
import net.sourceforge.pmd.eclipse.ui.model.ProjectRecord;
import net.sourceforge.pmd.eclipse.ui.views.ViolationOverview;
import net.sourceforge.pmd.eclipse.ui.views.actions.CalculateStatisticsAction;
import net.sourceforge.pmd.eclipse.ui.views.actions.CollapseAllAction;
import net.sourceforge.pmd.eclipse.ui.views.actions.PriorityFilterAction;
import net.sourceforge.pmd.eclipse.ui.views.actions.ProjectFilterAction;
import net.sourceforge.pmd.eclipse.ui.views.actions.ViolationPresentationTypeAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;

public class ViolationOverviewMenuManager {
    private final ViolationOverview overview;
    private PriorityFilterAction[] priorityActions;

    public ViolationOverviewMenuManager(ViolationOverview overview) {
        this.overview = overview;
    }

    public void setupActions() {
        RulePriority[] priorities = UISettings.currentPriorities(true);
        this.priorityActions = new PriorityFilterAction[priorities.length];
        int i = 0;
        while (i < priorities.length) {
            this.priorityActions[i] = new PriorityFilterAction(priorities[i], this.overview);
            boolean check = this.overview.getPriorityFilterList().contains(priorities[i].getPriority());
            this.priorityActions[i].setChecked(check);
            ++i;
        }
    }

    public void createActionBars(IToolBarManager manager) {
        CalculateStatisticsAction calculateStats = new CalculateStatisticsAction(this.overview);
        manager.add((IAction)calculateStats);
        manager.add((IContributionItem)new Separator());
        PriorityFilterAction[] priorityFilterActionArray = this.priorityActions;
        int n = this.priorityActions.length;
        int n2 = 0;
        while (n2 < n) {
            PriorityFilterAction priorityAction = priorityFilterActionArray[n2];
            manager.add((IAction)priorityAction);
            ++n2;
        }
        manager.add((IContributionItem)new Separator());
        CollapseAllAction collapseAllAction = new CollapseAllAction(this.overview.getViewer());
        manager.add((IAction)collapseAllAction);
    }

    public void createDropDownMenu(IMenuManager manager) {
        manager.removeAll();
        this.createProjectFilterMenu(manager);
        this.createShowTypeSubmenu(manager);
    }

    public void createContextMenu() {
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                MenuManager submenuManager = new MenuManager(ViolationOverviewMenuManager.this.getString("view.menu.resource_filter"));
                ViolationOverviewMenuManager.this.createProjectFilterMenu((IMenuManager)submenuManager);
                manager.add((IContributionItem)submenuManager);
                submenuManager = new MenuManager(ViolationOverviewMenuManager.this.getString("view.menu.priority_filter"));
                PriorityFilterAction[] priorityFilterActionArray = ViolationOverviewMenuManager.this.priorityActions;
                int n = priorityFilterActionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    PriorityFilterAction priorityAction = priorityFilterActionArray[n2];
                    submenuManager.add((IAction)priorityAction);
                    ++n2;
                }
                manager.add((IContributionItem)submenuManager);
                submenuManager = new MenuManager(ViolationOverviewMenuManager.this.getString("view.menu.show_type"));
                ViolationOverviewMenuManager.this.createShowTypeSubmenu((IMenuManager)submenuManager);
                manager.add((IContributionItem)submenuManager);
                manager.add((IContributionItem)new Separator("additions"));
                manager.add((IContributionItem)new Separator("additions-end"));
            }
        });
        Tree tree = this.overview.getViewer().getTree();
        tree.setMenu(manager.createContextMenu((Control)tree));
        this.overview.getSite().registerContextMenu(manager, (ISelectionProvider)this.overview.getViewer());
    }

    private void createProjectFilterMenu(IMenuManager manager) {
        List<AbstractPMDRecord> projectFilterList = this.overview.getProjectFilterList();
        ArrayList<ProjectRecord> projectList = new ArrayList<ProjectRecord>();
        AbstractPMDRecord[] projects = this.overview.getAllProjects();
        int i = 0;
        while (i < projects.length) {
            ProjectRecord project = (ProjectRecord)projects[i];
            if (project.hasMarkers()) {
                ProjectFilterAction projectFilterAction = new ProjectFilterAction(project, this.overview);
                if (!projectFilterList.contains(projects[i])) {
                    projectFilterAction.setChecked(true);
                }
                manager.add((IAction)projectFilterAction);
                projectList.add(project);
            }
            ++i;
        }
        manager.add((IContributionItem)new Separator());
    }

    private void createShowTypeSubmenu(IMenuManager manager) {
        ViolationPresentationTypeAction typeAction1 = new ViolationPresentationTypeAction(this.overview, 3);
        ViolationPresentationTypeAction typeAction2 = new ViolationPresentationTypeAction(this.overview, 2);
        ViolationPresentationTypeAction typeAction3 = new ViolationPresentationTypeAction(this.overview, 1);
        manager.add((IAction)typeAction1);
        manager.add((IAction)typeAction2);
        manager.add((IAction)typeAction3);
    }

    private String getString(String key) {
        return PMDPlugin.getDefault().getStringTable().getString(key);
    }
}

