/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.preferences.br;

import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.eclipse.ui.preferences.br.BasicRuleFieldAccessor;
import net.sourceforge.pmd.eclipse.ui.preferences.br.RuleCollection;
import net.sourceforge.pmd.eclipse.ui.preferences.br.RuleFieldAccessor;
import net.sourceforge.pmd.eclipse.ui.preferences.br.RuleUIUtil;
import net.sourceforge.pmd.eclipse.ui.preferences.br.SimpleColumnDescriptor;
import net.sourceforge.pmd.eclipse.ui.preferences.br.SortListener;
import net.sourceforge.pmd.eclipse.util.AbstractCellPainterBuilder;
import net.sourceforge.pmd.eclipse.util.ResourceManager;
import net.sourceforge.pmd.eclipse.util.Util;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class TextColumnDescriptor
extends SimpleColumnDescriptor {
    public static final RuleFieldAccessor ruleSetNameAcc = new BasicRuleFieldAccessor(){

        @Override
        public Comparable<?> valueFor(Rule rule) {
            return RuleUIUtil.ruleSetNameFrom(rule);
        }
    };
    public static final RuleFieldAccessor propertiesAcc = new BasicRuleFieldAccessor(){

        @Override
        public Comparable<?> valueFor(Rule rule) {
            return RuleUIUtil.propertyStringFrom(rule, "*");
        }
    };
    private static final int ImgOffset = 14;

    public TextColumnDescriptor(String theId, String theLabel, int theAlignment, int theWidth, RuleFieldAccessor theAccessor, boolean resizableFlag, String theImagePath) {
        super(theId, theLabel, theAlignment, theWidth, theAccessor, resizableFlag, theImagePath);
    }

    private static boolean isCheckboxTree(Tree tree) {
        return (tree.getStyle() | 0x20) > 0;
    }

    @Override
    public TreeColumn newTreeColumnFor(Tree parent, int columnIndex, SortListener sortListener, Map<Integer, List<Listener>> paintListeners) {
        TreeColumn tc = super.newTreeColumnFor(parent, columnIndex, sortListener, paintListeners);
        if (TextColumnDescriptor.isCheckboxTree(parent) && columnIndex != 0) {
            this.addPainterFor(tc.getParent(), columnIndex, this.accessor(), paintListeners);
        }
        return tc;
    }

    @Override
    public String stringValueFor(Rule rule) {
        return "";
    }

    @Override
    public String stringValueFor(RuleCollection collection) {
        return "";
    }

    @Override
    public Image imageFor(Rule rule) {
        boolean hasIssues = rule.dysfunctionReason() != null;
        return hasIssues ? ResourceManager.imageFor("icons/warn.gif") : null;
    }

    public void addPainterFor(Tree tree, int columnIndex, RuleFieldAccessor getter, Map<Integer, List<Listener>> thePaintListeners) {
        AbstractCellPainterBuilder cpl = new AbstractCellPainterBuilder(){

            @Override
            public void addPainterFor(final Tree tree, final int columnIndex, final RuleFieldAccessor getter, Map<Integer, List<Listener>> paintListeners) {
                Listener paintListener = new Listener(){

                    public void handleEvent(Event event) {
                        if (event.index != columnIndex) {
                            return;
                        }
                        Object value = ((TreeItem)event.item).getData();
                        if (value == null || value instanceof RuleCollection) {
                            return;
                        }
                        GC gc = event.gc;
                        int imgOffset = 0;
                        Rule rule = (Rule)value;
                        gc.setFont(this.fontFor((Control)tree, rule));
                        imgOffset = rule.dysfunctionReason() != null ? 14 : 0;
                        String text = this.textFor((TreeItem)event.item, getter);
                        int descent = gc.getFontMetrics().getDescent();
                        gc.drawString(text, event.x + imgOffset, event.y + descent, true);
                    }
                };
                Listener measureListener = new Listener(){

                    public void handleEvent(Event event) {
                        if (event.index != columnIndex) {
                            return;
                        }
                        String text = this.textFor((TreeItem)event.item, getter);
                        if (text == null) {
                            text = "";
                        }
                        Point size = event.gc.textExtent(text);
                        event.width = size.x + 6;
                    }
                };
                Util.addListener((Control)tree, 42, paintListener, paintListeners);
                Util.addListener((Control)tree, 41, measureListener, paintListeners);
            }
        };
        cpl.addPainterFor(tree, columnIndex, getter, thePaintListeners);
    }
}

