/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.preferences.br;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.lang.rule.properties.StringProperty;
import net.sourceforge.pmd.util.StringUtil;

public class FilterManager {
    private String newFilterPrefix;
    private final StringProperty filterPropertyDesc;
    private Map<String, List<Rule>> rulesByFilterName;
    private Map<Integer, String> namesByFilterHash;

    public FilterManager(StringProperty filterDesc, String filterPrefix) {
        this.filterPropertyDesc = filterDesc;
        this.newFilterPrefix = filterPrefix;
    }

    public void addFilter(String name, String source) {
    }

    public void addFilterFrom(Rule rule) {
        String filter;
        if (this.rulesByFilterName == null) {
            this.rulesByFilterName = new HashMap<String, List<Rule>>();
            this.namesByFilterHash = new HashMap<Integer, String>();
        }
        if (StringUtil.isEmpty((String)(filter = (String)rule.getProperty((PropertyDescriptor)this.filterPropertyDesc)))) {
            return;
        }
        int hashCode = (filter = filter.trim()).hashCode();
        String name = this.namesByFilterHash.get(hashCode);
        if (name == null) {
            name = this.newName();
            this.namesByFilterHash.put(hashCode, name);
            this.rulesByFilterName.put(name, new ArrayList());
        }
        this.rulesByFilterName.get(name).add(rule);
    }

    public void setFilter(String name, Rule rule) {
    }

    private String newName() {
        return String.valueOf(this.newFilterPrefix) + this.namesByFilterHash.size();
    }

    public void setName(String name, String filterSource) {
        int code = filterSource.trim().hashCode();
        this.namesByFilterHash.put(code, name);
    }

    public String[] names() {
        if (this.rulesByFilterName == null) {
            return StringUtil.EMPTY_STRINGS;
        }
        return this.rulesByFilterName.keySet().toArray(new String[this.rulesByFilterName.size()]);
    }

    public int referencesTo(String name) {
        if (this.rulesByFilterName == null) {
            return 0;
        }
        List<Rule> rules = this.rulesByFilterName.get(name);
        return rules == null ? 0 : rules.size();
    }

    public void modify(String name, String newSource) {
        if (this.rulesByFilterName == null) {
            return;
        }
        String theSource = newSource.trim();
        int hash = theSource.hashCode();
        this.namesByFilterHash.put(hash, name);
        for (Rule rule : this.rulesByFilterName.get(name)) {
            rule.setProperty((PropertyDescriptor)this.filterPropertyDesc, (Object)theSource);
        }
    }

    public void rename(String oldName, String newName) {
    }

    public void remove(String name) {
        for (Rule rule : this.rulesByFilterName.get(name)) {
            rule.setProperty((PropertyDescriptor)this.filterPropertyDesc, null);
        }
        this.rulesByFilterName.remove(name);
        int hashKey = 0;
        for (Map.Entry<Integer, String> entry : this.namesByFilterHash.entrySet()) {
            if (!entry.getValue().equals(name)) continue;
            hashKey = entry.getKey();
            break;
        }
        this.namesByFilterHash.remove(hashKey);
    }

    public void load() {
    }

    public void save() {
    }
}

