/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.model;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.springframework.ide.eclipse.beans.core.internal.model.Bean;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansConfig;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansJavaConfig;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeanAlias;
import org.springframework.ide.eclipse.beans.core.model.IBeanConstructorArgument;
import org.springframework.ide.eclipse.beans.core.model.IBeanMethodOverride;
import org.springframework.ide.eclipse.beans.core.model.IBeanProperty;
import org.springframework.ide.eclipse.beans.core.model.IBeanReference;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfigSet;
import org.springframework.ide.eclipse.beans.core.model.IBeansImport;
import org.springframework.ide.eclipse.beans.core.model.IBeansList;
import org.springframework.ide.eclipse.beans.core.model.IBeansMap;
import org.springframework.ide.eclipse.beans.core.model.IBeansMapEntry;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.beans.core.model.IBeansProperties;
import org.springframework.ide.eclipse.beans.core.model.IBeansSet;
import org.springframework.ide.eclipse.beans.core.model.IBeansTypedString;
import org.springframework.ide.eclipse.beans.ui.BeansUIImages;
import org.springframework.ide.eclipse.beans.ui.BeansUIPlugin;
import org.springframework.ide.eclipse.beans.ui.model.BeansModelImageFlags;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.ISpringProject;
import org.springframework.ide.eclipse.core.model.ModelUtils;
import org.springframework.ide.eclipse.ui.AbstractCompositeImageDescriptor;

public final class BeansModelImages
implements BeansModelImageFlags {
    public static Image getImage(IModelElement element) {
        return BeansModelImages.getImage(element, null, true);
    }

    public static Image getImage(IModelElement element, IModelElement context, boolean isDecorationg) {
        if (element instanceof ISpringProject || element instanceof IBeansProject) {
            return BeansUIImages.getImage("org.springframework.ide.eclipse.beans.ui.project_obj.gif");
        }
        if (element instanceof BeansConfig) {
            Image image = BeansUIImages.getImage("org.springframework.ide.eclipse.beans.ui.config_obj.gif");
            if (isDecorationg) {
                image = BeansModelImages.getDecoratedImage(image, element, context);
            }
            return image;
        }
        if (element instanceof BeansJavaConfig) {
            BeansJavaConfig javaConfig = (BeansJavaConfig)element;
            Image image = WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider().getImage((Object)javaConfig.getConfigClass());
            if (isDecorationg) {
                image = BeansModelImages.getDecoratedImage(image, element, context);
            }
            return image;
        }
        if (element instanceof IBeansConfigSet) {
            return BeansUIImages.getImage("org.springframework.ide.eclipse.beans.ui.configset_obj.gif");
        }
        if (element instanceof IBeansImport) {
            return BeansUIImages.getImage("org.springframework.ide.eclipse.beans.ui.import_obj.gif");
        }
        if (element instanceof IBeanAlias) {
            return BeansUIImages.getImage("org.springframework.ide.eclipse.beans.ui.alias_obj.gif");
        }
        if (element instanceof IBean) {
            Image image = BeansUIImages.getImage("org.springframework.ide.eclipse.beans.ui.bean_obj.gif");
            if (isDecorationg) {
                image = BeansModelImages.getDecoratedImage(image, element, context);
            }
            return image;
        }
        if (element instanceof IBeanConstructorArgument) {
            return BeansUIImages.getImage("org.springframework.ide.eclipse.beans.ui.constructor_obj.gif");
        }
        if (element instanceof IBeanProperty) {
            return BeansUIImages.getImage("org.springframework.ide.eclipse.beans.ui.property_obj.gif");
        }
        if (element instanceof IBeansList || element instanceof IBeansSet) {
            return BeansUIImages.getImage("org.springframework.ide.eclipse.beans.ui.list_obj.gif");
        }
        if (element instanceof IBeansMap) {
            return BeansUIImages.getImage("org.springframework.ide.eclipse.beans.ui.map_obj.gif");
        }
        if (element instanceof IBeanMethodOverride) {
            return BeansUIImages.getImage("org.springframework.ide.eclipse.beans.ui.method_override_obj.gif");
        }
        if (element instanceof IBeansProperties) {
            return BeansUIImages.getImage("org.springframework.ide.eclipse.beans.ui.properties_obj.gif");
        }
        if (element instanceof IBeansMapEntry) {
            return BeansUIImages.getImage("org.springframework.ide.eclipse.beans.ui.collection_obj.gif");
        }
        if (element instanceof IBeanReference) {
            return BeansUIImages.getImage("org.springframework.ide.eclipse.beans.ui.arrow_obj.gif");
        }
        if (element instanceof IBeansTypedString) {
            if (element.getElementParent() instanceof IBeansMapEntry && element.equals(((IBeansMapEntry)element.getElementParent()).getKey())) {
                return BeansUIImages.getImage("org.springframework.ide.eclipse.beans.ui.key_obj.gif");
            }
            return BeansUIImages.getImage("org.springframework.ide.eclipse.beans.ui.value_obj.gif");
        }
        return BeansUIImages.getImage("org.springframework.ide.eclipse.beans.ui.spring_obj.gif");
    }

    public static Image getDecoratedImage(Image baseImage, IModelElement element, IModelElement context) {
        int flags = BeansModelImages.getFlags(element, context);
        BeansModelCompositeImageDescriptor descriptor = new BeansModelCompositeImageDescriptor(baseImage, flags);
        return BeansUIPlugin.getImageDescriptorRegistry().get((ImageDescriptor)descriptor);
    }

    public static Image getDecoratedImage(String baseImageKey, int flags) {
        return BeansModelImages.getDecoratedImage(BeansUIImages.getImage(baseImageKey), flags);
    }

    public static Image getDecoratedImage(Image baseImage, int flags) {
        BeansModelCompositeImageDescriptor descriptor = new BeansModelCompositeImageDescriptor(baseImage, flags);
        return BeansUIPlugin.getImageDescriptorRegistry().get((ImageDescriptor)descriptor);
    }

    protected static int getFlags(IModelElement element, IModelElement context) {
        int flags = 0;
        if (element instanceof IBeansConfig) {
            if (ModelUtils.isExternal((IModelElement)element, (IModelElement)context)) {
                flags |= 8;
            }
        } else if (element instanceof Bean && ModelUtils.isExternal((IModelElement)element, (IModelElement)context)) {
            flags |= 8;
        }
        return flags;
    }

    private static class BeansModelCompositeImageDescriptor
    extends AbstractCompositeImageDescriptor {
        public BeansModelCompositeImageDescriptor(Image baseImage, int flags) {
            super(baseImage, flags);
        }

        protected void drawOverlays() {
            int flags = this.getFlags();
            if ((flags & 8) != 0) {
                ImageData data = BeansUIImages.DESC_OVR_EXTERNAL.getImageData();
                this.drawImage(data, this.getSize().x - data.width, this.getSize().y - data.height);
            }
        }
    }
}

