/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.editor.hyperlink.webflow;

import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.ui.editor.hyperlink.IHyperlinkCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.hyperlink.JavaElementHyperlink;
import org.springframework.ide.eclipse.beans.ui.editor.util.BeansEditorUtils;
import org.springframework.ide.eclipse.core.java.Introspector;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.ide.eclipse.webflow.core.Activator;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowModelUtils;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowConfig;
import org.w3c.dom.Node;

public class WebflowActionMethodHyperlinkCalculator
implements IHyperlinkCalculator {
    public IHyperlink createHyperlink(String name, String target, Node node, Node parentNode, IDocument document, ITextViewer textViewer, IRegion hyperlinkRegion, IRegion cursor) {
        if (BeansEditorUtils.hasAttribute((Node)node, (String)"bean")) {
            IWebflowConfig config;
            String bean = BeansEditorUtils.getAttribute((Node)node, (String)"bean");
            IFile file = BeansEditorUtils.getFile((IDocument)document);
            if (file != null && file.exists() && (config = Activator.getModel().getProject(file.getProject()).getConfig(file)) != null) {
                String className = null;
                Set beans = WebflowModelUtils.getBeans((IWebflowConfig)config);
                for (IBean modelBean : beans) {
                    if (!modelBean.getElementName().equals(bean)) continue;
                    className = BeansModelUtils.getBeanClass((IBean)modelBean, null);
                }
                IType type = JdtUtils.getJavaType((IProject)file.getProject(), className);
                if (type != null) {
                    try {
                        Set methods = Introspector.getAllMethods((IType)type);
                        if (methods != null) {
                            for (IMethod method : methods) {
                                if (!method.getElementName().equals(target)) continue;
                                return new JavaElementHyperlink(hyperlinkRegion, (IJavaElement)method);
                            }
                        }
                    }
                    catch (JavaModelException javaModelException) {}
                }
            }
        }
        return null;
    }
}

