/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.commons.crucible.api.model;

import com.atlassian.theplugin.commons.util.MiscUtil;
import java.util.Map;

public final class CrucibleAction {
    private static Map<String, CrucibleAction> nameMap = MiscUtil.buildHashMap();
    public static final CrucibleAction VIEW = new CrucibleAction("View review", "action:viewReview");
    public static final CrucibleAction CREATE = new CrucibleAction("Create review", "action:createReview");
    public static final CrucibleAction ABANDON = new CrucibleAction("Abandon review", "action:abandonReview");
    public static final CrucibleAction SUBMIT = new CrucibleAction("Submit review", "action:submitReview");
    public static final CrucibleAction APPROVE = new CrucibleAction("Approve review", "action:approveReview");
    public static final CrucibleAction REJECT = new CrucibleAction("Reject review", "action:rejectReview");
    public static final CrucibleAction SUMMARIZE = new CrucibleAction("Summarize review", "action:summarizeReview");
    public static final CrucibleAction CLOSE = new CrucibleAction("Close review", "action:closeReview");
    public static final CrucibleAction REOPEN = new CrucibleAction("Reopen review", "action:reopenReview");
    public static final CrucibleAction RECOVER = new CrucibleAction("Recover review", "action:recoverReview");
    public static final CrucibleAction COMPLETE = new CrucibleAction("Complete review", "action:completeReview");
    public static final CrucibleAction UNCOMPLETE = new CrucibleAction("Uncomplete review", "action:uncompleteReview");
    public static final CrucibleAction COMMENT = new CrucibleAction("Comment", "action:commentOnReview");
    public static final CrucibleAction MODIFY_FILES = new CrucibleAction("Modify files", "action:modifyReviewFiles");
    public static final CrucibleAction DELETE = new CrucibleAction("Delete review", "action:deleteReview");
    public static final CrucibleAction REOPEN_SNIPPET = new CrucibleAction("Reopen snippet", "action:reopenSnippet");
    public static final CrucibleAction CLOSE_SNIPPET = new CrucibleAction("Close snippet", "action:closeSnippet");
    public static final CrucibleAction CREATE_SNIPPET = new CrucibleAction("Create snippet", "action:createSnippet");
    private final String displayName;
    private final String id;

    public CrucibleAction(String displayName, String id) {
        this.displayName = displayName;
        this.id = id;
        nameMap.put(id, this);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        return String.valueOf(this.id) + " (" + this.displayName + ")";
    }

    public static CrucibleAction fromValue(String v) {
        CrucibleAction crucibleAction = nameMap.get(v);
        if (crucibleAction != null) {
            return crucibleAction;
        }
        throw new IllegalArgumentException(v);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CrucibleAction other = (CrucibleAction)obj;
        if (this.displayName == null ? other.displayName != null : !this.displayName.equals(other.displayName)) {
            return false;
        }
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }
}

