/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.commons.jira;

import com.atlassian.connector.commons.api.ConnectionCfg;
import com.atlassian.connector.commons.jira.JIRAAction;
import com.atlassian.connector.commons.jira.JIRAActionField;
import com.atlassian.connector.commons.jira.JIRAIssue;
import com.atlassian.connector.commons.jira.JIRAServerFacade2;
import com.atlassian.connector.commons.jira.JIRASessionPartOne;
import com.atlassian.connector.commons.jira.JiraUserNotFoundException;
import com.atlassian.connector.commons.jira.beans.JIRAAttachment;
import com.atlassian.connector.commons.jira.beans.JIRAComment;
import com.atlassian.connector.commons.jira.beans.JIRAComponentBean;
import com.atlassian.connector.commons.jira.beans.JIRAConstant;
import com.atlassian.connector.commons.jira.beans.JIRAPriorityBean;
import com.atlassian.connector.commons.jira.beans.JIRAProject;
import com.atlassian.connector.commons.jira.beans.JIRAQueryFragment;
import com.atlassian.connector.commons.jira.beans.JIRAResolutionBean;
import com.atlassian.connector.commons.jira.beans.JIRASavedFilter;
import com.atlassian.connector.commons.jira.beans.JIRASecurityLevelBean;
import com.atlassian.connector.commons.jira.beans.JIRAUserBean;
import com.atlassian.connector.commons.jira.beans.JIRAVersionBean;
import com.atlassian.connector.commons.jira.beans.JiraFilter;
import com.atlassian.connector.commons.jira.rss.JIRAException;
import com.atlassian.connector.commons.jira.rss.JIRARssClient;
import com.atlassian.connector.commons.jira.rss.JiraRssAutoRenewClient;
import com.atlassian.connector.commons.jira.soap.AxisSessionCallback;
import com.atlassian.connector.commons.jira.soap.JIRASoapSessionImpl;
import com.atlassian.theplugin.commons.ServerType;
import com.atlassian.theplugin.commons.jira.JiraServerData;
import com.atlassian.theplugin.commons.remoteapi.CaptchaRequiredException;
import com.atlassian.theplugin.commons.remoteapi.RemoteApiException;
import com.atlassian.theplugin.commons.remoteapi.RemoteApiLoginException;
import com.atlassian.theplugin.commons.remoteapi.jira.JiraCaptchaRequiredException;
import com.atlassian.theplugin.commons.remoteapi.rest.HttpSessionCallback;
import com.atlassian.theplugin.commons.util.Logger;
import java.net.MalformedURLException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.rpc.ServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JIRASoapAndXmlServerFacade2Impl
implements JIRAServerFacade2 {
    private final HttpSessionCallback callback;
    private final AxisSessionCallback axisCallback;
    private static Logger logger;
    private final Map<String, JiraRssAutoRenewClient> rssSessions = new HashMap<String, JiraRssAutoRenewClient>();
    private final Map<String, JIRASessionPartOne> soapSessions = new HashMap<String, JIRASessionPartOne>();
    private static final long ONE_MINUTE = 60000L;

    private String getSessionKey(ConnectionCfg httpConnectionCfg) {
        return String.valueOf(httpConnectionCfg.getUrl()) + "_" + httpConnectionCfg.getUsername() + "_" + httpConnectionCfg.getPassword();
    }

    public JIRASoapAndXmlServerFacade2Impl(HttpSessionCallback callback, AxisSessionCallback axisCallback) {
        this.callback = callback;
        this.axisCallback = axisCallback;
    }

    @Override
    public void reset() {
        this.rssSessions.clear();
        this.soapSessions.clear();
    }

    @Override
    public boolean usesRest(JiraServerData jiraServerData) {
        return false;
    }

    public static void setLogger(Logger logger) {
        JIRASoapAndXmlServerFacade2Impl.logger = logger;
    }

    private synchronized JIRASessionPartOne getSoapSession(ConnectionCfg connectionCfg) throws RemoteApiException {
        String key = this.getSessionKey(connectionCfg);
        JIRASessionPartOne session = this.soapSessions.get(key);
        if (session == null || ((JIRASoapSessionImpl)session).getLastUsed().getTime() < new Date().getTime() - 60000L) {
            if (session != null) {
                this.soapSessions.remove(key);
            }
            try {
                session = new JIRASoapSessionImpl(logger, connectionCfg, this.axisCallback);
            }
            catch (MalformedURLException e) {
                throw new RemoteApiException(e);
            }
            catch (ServiceException e) {
                throw new RemoteApiException(e);
            }
            session.login(connectionCfg.getUsername(), connectionCfg.getPassword());
            this.soapSessions.put(key, session);
        }
        return session;
    }

    private synchronized JiraRssAutoRenewClient getRssSession(ConnectionCfg server) throws RemoteApiException {
        String key = this.getSessionKey(server);
        JiraRssAutoRenewClient session = this.rssSessions.get(key);
        if (session == null || session.getLastUsed().getTime() < new Date().getTime() - 60000L) {
            JIRARssClient client = new JIRARssClient(server, this.callback);
            try {
                this.callback.disposeClient(server);
                client.login();
            }
            catch (JiraCaptchaRequiredException e) {
                throw new CaptchaRequiredException(e);
            }
            catch (JIRAException e) {
                throw new RemoteApiException(e);
            }
            session = new JiraRssAutoRenewClient(client);
            this.rssSessions.put(key, session);
        }
        session.setLastUsed(new Date());
        return session;
    }

    private synchronized void removeRssSession(ConnectionCfg server) {
        this.rssSessions.remove(this.getSessionKey(server));
    }

    @Override
    public void testServerConnection(ConnectionCfg httpConnectionCfg) throws RemoteApiException {
        JIRASoapSessionImpl session;
        try {
            session = new JIRASoapSessionImpl(logger, httpConnectionCfg, this.axisCallback);
        }
        catch (MalformedURLException e) {
            throw new RemoteApiException(e);
        }
        catch (ServiceException e) {
            throw new RemoteApiLoginException(e.getMessage(), e);
        }
        session.login(httpConnectionCfg.getUsername(), httpConnectionCfg.getPassword());
    }

    @Override
    public ServerType getServerType() {
        return ServerType.JIRA_SERVER;
    }

    @Override
    public List<JIRAIssue> getIssues(ConnectionCfg httpConnectionCfg, JiraFilter filter, String sort, String sortOrder, int start, int size) throws JIRAException {
        try {
            JiraRssAutoRenewClient rss = this.getRssSession(httpConnectionCfg);
            return rss.getIssues(filter, sort, sortOrder, start, size);
        }
        catch (CaptchaRequiredException e) {
            this.removeRssSession(httpConnectionCfg);
            throw new JiraCaptchaRequiredException(e.getMessage());
        }
        catch (RemoteApiException e) {
            this.removeRssSession(httpConnectionCfg);
            throw new JIRAException(e.getMessage(), e);
        }
    }

    @Override
    public List<JIRAIssue> getIssues(JiraServerData server, String query, String sort, String sortOrder, int start, int size) throws JIRAException {
        throw new JIRAException("Not implemented");
    }

    @Override
    public List<JIRAIssue> getSavedFilterIssues(ConnectionCfg httpConnectionCfg, JIRASavedFilter filter, String sort, String sortOrder, int start, int size) throws JIRAException {
        try {
            JiraRssAutoRenewClient rss = this.getRssSession(httpConnectionCfg);
            return rss.getSavedFilterIssues(filter, sort, sortOrder, start, size);
        }
        catch (CaptchaRequiredException e) {
            this.removeRssSession(httpConnectionCfg);
            throw new JiraCaptchaRequiredException(e.getMessage());
        }
        catch (RemoteApiException e) {
            this.removeRssSession(httpConnectionCfg);
            throw new JIRAException(e.getMessage(), e);
        }
    }

    @Override
    public JIRAIssue getIssue(ConnectionCfg httpConnectionCfg, String key) throws JIRAException {
        try {
            JiraRssAutoRenewClient rss = this.getRssSession(httpConnectionCfg);
            return rss.getIssue(key);
        }
        catch (CaptchaRequiredException e) {
            this.removeRssSession(httpConnectionCfg);
            throw new JiraCaptchaRequiredException(e.getMessage());
        }
        catch (RemoteApiException e) {
            this.removeRssSession(httpConnectionCfg);
            throw new JIRAException(e.getMessage(), e);
        }
    }

    @Override
    public List<JIRAProject> getProjects(ConnectionCfg server) throws JIRAException {
        try {
            JIRASessionPartOne soap = this.getSoapSession(server);
            return soap.getProjects();
        }
        catch (CaptchaRequiredException e) {
            this.removeRssSession(server);
            throw new JiraCaptchaRequiredException(e.getMessage());
        }
        catch (RemoteApiException e) {
            this.soapSessions.remove(this.getSessionKey(server));
            try {
                if (e.getMessage().contains("User not authenticated yet, or session timed out.")) {
                    JIRASessionPartOne soap = null;
                    soap = this.getSoapSession(server);
                    return soap.getProjects();
                }
            }
            catch (RemoteApiException remoteApiException) {
                throw new JIRAException(e.getMessage(), e);
            }
            throw new JIRAException(e.getMessage(), e);
        }
    }

    @Override
    public List<JIRAProject> getProjectsForIssueCreation(ConnectionCfg httpConnectionCfg) throws JIRAException {
        return this.getProjects(httpConnectionCfg);
    }

    @Override
    public List<JIRAConstant> getIssueTypes(ConnectionCfg httpConnectionCfg) throws JIRAException {
        try {
            JIRASessionPartOne soap = this.getSoapSession(httpConnectionCfg);
            return soap.getIssueTypes();
        }
        catch (CaptchaRequiredException e) {
            this.removeRssSession(httpConnectionCfg);
            throw new JiraCaptchaRequiredException(e.getMessage());
        }
        catch (RemoteApiException e) {
            this.soapSessions.remove(this.getSessionKey(httpConnectionCfg));
            try {
                if (e.getMessage().contains("User not authenticated yet, or session timed out.")) {
                    JIRASessionPartOne soap = this.getSoapSession(httpConnectionCfg);
                    return soap.getIssueTypes();
                }
            }
            catch (RemoteApiException remoteApiException) {
                throw new JIRAException(e.getMessage(), e);
            }
            throw new JIRAException(e.getMessage(), e);
        }
    }

    @Override
    public List<JIRAConstant> getIssueTypesForProject(ConnectionCfg httpConnectionCfg, long projectId, String projectKey) throws JIRAException {
        try {
            JIRASessionPartOne soap = this.getSoapSession(httpConnectionCfg);
            return soap.getIssueTypesForProject(projectId, projectKey);
        }
        catch (CaptchaRequiredException e) {
            this.removeRssSession(httpConnectionCfg);
            throw new JiraCaptchaRequiredException(e.getMessage());
        }
        catch (RemoteApiException e) {
            this.soapSessions.remove(this.getSessionKey(httpConnectionCfg));
            try {
                if (e.getMessage().contains("User not authenticated yet, or session timed out.")) {
                    JIRASessionPartOne soap = this.getSoapSession(httpConnectionCfg);
                    return soap.getIssueTypesForProject(projectId, projectKey);
                }
            }
            catch (RemoteApiException remoteApiException) {
                throw new JIRAException(e.getMessage(), e);
            }
            throw new JIRAException(e.getMessage(), e);
        }
    }

    @Override
    public List<JIRAConstant> getSubtaskIssueTypes(ConnectionCfg httpConnectionCfg) throws JIRAException {
        try {
            JIRASessionPartOne soap = this.getSoapSession(httpConnectionCfg);
            return soap.getSubtaskIssueTypes();
        }
        catch (CaptchaRequiredException e) {
            this.removeRssSession(httpConnectionCfg);
            throw new JiraCaptchaRequiredException(e.getMessage());
        }
        catch (RemoteApiException e) {
            this.soapSessions.remove(this.getSessionKey(httpConnectionCfg));
            try {
                if (e.getMessage().contains("User not authenticated yet, or session timed out.")) {
                    JIRASessionPartOne soap = this.getSoapSession(httpConnectionCfg);
                    return soap.getSubtaskIssueTypes();
                }
            }
            catch (RemoteApiException remoteApiException) {
                throw new JIRAException(e.getMessage(), e);
            }
            throw new JIRAException(e.getMessage(), e);
        }
    }

    @Override
    public List<JIRAConstant> getSubtaskIssueTypesForProject(ConnectionCfg connectionCfg, long projectId, String projectKey) throws JIRAException {
        try {
            JIRASessionPartOne soap = this.getSoapSession(connectionCfg);
            return soap.getSubtaskIssueTypesForProject(projectId, projectKey);
        }
        catch (CaptchaRequiredException e) {
            this.removeRssSession(connectionCfg);
            throw new JiraCaptchaRequiredException(e.getMessage());
        }
        catch (RemoteApiException e) {
            this.soapSessions.remove(this.getSessionKey(connectionCfg));
            try {
                if (e.getMessage().contains("User not authenticated yet, or session timed out.")) {
                    JIRASessionPartOne soap = this.getSoapSession(connectionCfg);
                    return soap.getSubtaskIssueTypesForProject(projectId, projectKey);
                }
            }
            catch (RemoteApiException remoteApiException) {
                throw new JIRAException(e.getMessage(), e);
            }
            throw new JIRAException(e.getMessage(), e);
        }
    }

    @Override
    public List<JIRAConstant> getStatuses(ConnectionCfg connection) throws JIRAException {
        try {
            JIRASessionPartOne soap = this.getSoapSession(connection);
            return soap.getStatuses();
        }
        catch (CaptchaRequiredException e) {
            this.removeRssSession(connection);
            throw new JiraCaptchaRequiredException(e.getMessage());
        }
        catch (RemoteApiException e) {
            this.soapSessions.remove(this.getSessionKey(connection));
            try {
                if (e.getMessage().contains("User not authenticated yet, or session timed out.")) {
                    JIRASessionPartOne soap = this.getSoapSession(connection);
                    return soap.getStatuses();
                }
            }
            catch (RemoteApiException remoteApiException) {
                throw new JIRAException(e.getMessage(), e);
            }
            throw new JIRAException(e.getMessage(), e);
        }
    }

    @Override
    public void addComment(ConnectionCfg connectionCfg, String issueKey, String comment) throws JIRAException {
        try {
            JIRASessionPartOne soap = this.getSoapSession(connectionCfg);
            soap.addComment(issueKey, comment);
        }
        catch (CaptchaRequiredException e) {
            this.removeRssSession(connectionCfg);
            throw new JiraCaptchaRequiredException(e.getMessage());
        }
        catch (RemoteApiException e) {
            this.soapSessions.remove(this.getSessionKey(connectionCfg));
            try {
                if (e.getMessage().contains("User not authenticated yet, or session timed out.")) {
                    JIRASessionPartOne soap = this.getSoapSession(connectionCfg);
                    soap.addComment(issueKey, comment);
                }
            }
            catch (RemoteApiException remoteApiException) {
                throw new JIRAException(e.getMessage(), e);
            }
            throw new JIRAException(e.getMessage(), e);
        }
    }

    @Override
    public void addAttachment(ConnectionCfg connectionCfg, String issueKey, String name, byte[] content) throws JIRAException {
        try {
            JIRASessionPartOne soap = this.getSoapSession(connectionCfg);
            soap.addAttachment(issueKey, name, content);
        }
        catch (CaptchaRequiredException e) {
            this.removeRssSession(connectionCfg);
            throw new JiraCaptchaRequiredException(e.getMessage());
        }
        catch (RemoteApiException e) {
            this.soapSessions.remove(this.getSessionKey(connectionCfg));
            try {
                if (e.getMessage().contains("User not authenticated yet, or session timed out.")) {
                    JIRASessionPartOne soap = this.getSoapSession(connectionCfg);
                    soap.addAttachment(issueKey, name, content);
                }
            }
            catch (RemoteApiException remoteApiException) {
                throw new JIRAException(e.getMessage(), e);
            }
            throw new JIRAException(e.getMessage(), e);
        }
    }

    @Override
    public JIRAIssue createIssue(ConnectionCfg connectionCfg, JIRAIssue issue) throws JIRAException {
        try {
            JIRASessionPartOne soap = this.getSoapSession(connectionCfg);
            JIRAIssue i = soap.createIssue(issue);
            return this.getIssue(connectionCfg, i.getKey());
        }
        catch (CaptchaRequiredException e) {
            this.removeRssSession(connectionCfg);
            throw new JiraCaptchaRequiredException(e.getMessage());
        }
        catch (RemoteApiException e) {
            this.soapSessions.remove(this.getSessionKey(connectionCfg));
            try {
                if (e.getMessage().contains("User not authenticated yet, or session timed out.")) {
                    JIRASessionPartOne soap = this.getSoapSession(connectionCfg);
                    JIRAIssue i = soap.createIssue(issue);
                    return this.getIssue(connectionCfg, i.getKey());
                }
            }
            catch (RemoteApiException remoteApiException) {
                throw new JIRAException(e.getMessage(), e);
            }
            throw new JIRAException(e.getMessage(), e);
        }
    }

    @Override
    public JIRAIssue createSubtask(JiraServerData jiraServerData, JIRAIssue parent, JIRAIssue issue) throws JIRAException {
        throw new JIRAException("SOAP JIRA API does not support issue subtask creation");
    }

    @Override
    public void logWork(ConnectionCfg connectionCfg, JIRAIssue issue, String timeSpent, Calendar startDate, String comment, boolean updateEstimate, String newEstimate) throws JIRAException {
        try {
            JIRASessionPartOne soap = this.getSoapSession(connectionCfg);
            soap.logWork(issue, timeSpent, startDate, comment, updateEstimate, newEstimate);
        }
        catch (CaptchaRequiredException e) {
            this.removeRssSession(connectionCfg);
            throw new JiraCaptchaRequiredException(e.getMessage());
        }
        catch (RemoteApiException e) {
            this.soapSessions.remove(this.getSessionKey(connectionCfg));
            try {
                if (e.getMessage().contains("User not authenticated yet, or session timed out.")) {
                    JIRASessionPartOne soap = this.getSoapSession(connectionCfg);
                    soap.logWork(issue, timeSpent, startDate, comment, updateEstimate, newEstimate);
                }
            }
            catch (RemoteApiException remoteApiException) {
                throw new JIRAException(e.getMessage(), e);
            }
            throw new JIRAException(e.getMessage(), e);
        }
    }

    @Override
    public List<JIRAComponentBean> getComponents(ConnectionCfg connectionCfg, String projectKey) throws JIRAException {
        try {
            JIRASessionPartOne soap = this.getSoapSession(connectionCfg);
            return soap.getComponents(projectKey);
        }
        catch (CaptchaRequiredException e) {
            this.removeRssSession(connectionCfg);
            throw new JiraCaptchaRequiredException(e.getMessage());
        }
        catch (RemoteApiException e) {
            this.soapSessions.remove(this.getSessionKey(connectionCfg));
            try {
                if (e.getMessage().contains("User not authenticated yet, or session timed out.")) {
                    JIRASessionPartOne soap = this.getSoapSession(connectionCfg);
                    return soap.getComponents(projectKey);
                }
            }
            catch (RemoteApiException remoteApiException) {
                throw new JIRAException(e.getMessage(), e);
            }
            throw new JIRAException(e.getMessage(), e);
        }
    }

    @Override
    public List<JIRAVersionBean> getVersions(ConnectionCfg connectionCfg, String projectKey) throws JIRAException {
        try {
            JIRASessionPartOne soap = this.getSoapSession(connectionCfg);
            return soap.getVersions(projectKey);
        }
        catch (CaptchaRequiredException e) {
            this.removeRssSession(connectionCfg);
            throw new JiraCaptchaRequiredException(e.getMessage());
        }
        catch (RemoteApiException e) {
            this.soapSessions.remove(this.getSessionKey(connectionCfg));
            if (e == null) {
                logger.warn("PL-1710: e is null");
            } else if (e.getMessage() == null) {
                logger.warn("PL-1710: e.getMessage() is null");
            }
            try {
                if (e != null && e.getMessage().contains("User not authenticated yet, or session timed out.")) {
                    JIRASessionPartOne soap = this.getSoapSession(connectionCfg);
                    return soap.getVersions(projectKey);
                }
            }
            catch (RemoteApiException remoteApiException) {
                throw new JIRAException(e.getMessage(), e);
            }
            throw new JIRAException(e.getMessage(), e);
        }
    }

    @Override
    public List<JIRAPriorityBean> getPriorities(ConnectionCfg connectionCfg) throws JIRAException {
        try {
            JIRASessionPartOne soap = this.getSoapSession(connectionCfg);
            return soap.getPriorities();
        }
        catch (CaptchaRequiredException e) {
            this.removeRssSession(connectionCfg);
            throw new JiraCaptchaRequiredException(e.getMessage());
        }
        catch (RemoteApiException e) {
            this.soapSessions.remove(this.getSessionKey(connectionCfg));
            try {
                if (e != null && e.getMessage().contains("User not authenticated yet, or session timed out.")) {
                    JIRASessionPartOne soap = this.getSoapSession(connectionCfg);
                    return soap.getPriorities();
                }
            }
            catch (RemoteApiException remoteApiException) {
                throw new JIRAException(e.getMessage(), e);
            }
            throw new JIRAException(e.getMessage(), e);
        }
    }

    @Override
    public List<JIRAResolutionBean> getResolutions(ConnectionCfg connectionCfg) throws JIRAException {
        try {
            JIRASessionPartOne soap = this.getSoapSession(connectionCfg);
            return soap.getResolutions();
        }
        catch (CaptchaRequiredException e) {
            this.removeRssSession(connectionCfg);
            throw new JiraCaptchaRequiredException(e.getMessage());
        }
        catch (RemoteApiException e) {
            this.soapSessions.remove(this.getSessionKey(connectionCfg));
            try {
                if (e != null && e.getMessage().contains("User not authenticated yet, or session timed out.")) {
                    JIRASessionPartOne soap = this.getSoapSession(connectionCfg);
                    return soap.getResolutions();
                }
            }
            catch (RemoteApiException remoteApiException) {
                throw new JIRAException(e.getMessage(), e);
            }
            throw new JIRAException(e.getMessage(), e);
        }
    }

    @Override
    public List<JIRAQueryFragment> getSavedFilters(ConnectionCfg connectionCfg) throws JIRAException {
        try {
            JIRASessionPartOne soap = this.getSoapSession(connectionCfg);
            return soap.getSavedFilters();
        }
        catch (CaptchaRequiredException e) {
            this.removeRssSession(connectionCfg);
            throw new JiraCaptchaRequiredException(e.getMessage());
        }
        catch (RemoteApiException e) {
            this.soapSessions.remove(this.getSessionKey(connectionCfg));
            try {
                if (e != null && e.getMessage().contains("User not authenticated yet, or session timed out.")) {
                    JIRASessionPartOne soap = this.getSoapSession(connectionCfg);
                    return soap.getSavedFilters();
                }
            }
            catch (RemoteApiException remoteApiException) {
                throw new JIRAException(e.getMessage(), e);
            }
            throw new JIRAException(e.getMessage(), e);
        }
    }

    @Override
    public List<JIRAAction> getAvailableActions(ConnectionCfg connectionCfg, JIRAIssue issue) throws JIRAException {
        try {
            JIRASessionPartOne soap = this.getSoapSession(connectionCfg);
            return soap.getAvailableActions(issue);
        }
        catch (CaptchaRequiredException e) {
            this.removeRssSession(connectionCfg);
            throw new JiraCaptchaRequiredException(e.getMessage());
        }
        catch (RemoteApiException e) {
            this.soapSessions.remove(this.getSessionKey(connectionCfg));
            try {
                if (e != null && e.getMessage().contains("User not authenticated yet, or session timed out.")) {
                    JIRASessionPartOne soap = this.getSoapSession(connectionCfg);
                    return soap.getAvailableActions(issue);
                }
            }
            catch (RemoteApiException remoteApiException) {
                throw new JIRAException(e.getMessage(), e);
            }
            throw new JIRAException(e.getMessage(), e);
        }
    }

    @Override
    public List<JIRAActionField> getFieldsForAction(ConnectionCfg connectionCfg, JIRAIssue issue, JIRAAction action) throws JIRAException {
        try {
            JIRASessionPartOne soap = this.getSoapSession(connectionCfg);
            return soap.getFieldsForAction(issue, action);
        }
        catch (CaptchaRequiredException e) {
            this.removeRssSession(connectionCfg);
            throw new JiraCaptchaRequiredException(e.getMessage());
        }
        catch (RemoteApiException e) {
            this.soapSessions.remove(this.getSessionKey(connectionCfg));
            try {
                if (e != null && e.getMessage().contains("User not authenticated yet, or session timed out.")) {
                    JIRASessionPartOne soap = this.getSoapSession(connectionCfg);
                    return soap.getFieldsForAction(issue, action);
                }
            }
            catch (RemoteApiException remoteApiException) {
                throw new JIRAException(e.getMessage(), e);
            }
            throw new JIRAException(e.getMessage(), e);
        }
    }

    @Override
    public void setField(ConnectionCfg connectionCfg, JIRAIssue issue, String fieldId, String value) throws JIRAException {
        try {
            JIRASessionPartOne soap = this.getSoapSession(connectionCfg);
            soap.setField(issue, fieldId, value);
        }
        catch (CaptchaRequiredException e) {
            this.removeRssSession(connectionCfg);
            throw new JiraCaptchaRequiredException(e.getMessage());
        }
        catch (RemoteApiException e) {
            this.soapSessions.remove(this.getSessionKey(connectionCfg));
            try {
                if (e != null && e.getMessage().contains("User not authenticated yet, or session timed out.")) {
                    JIRASessionPartOne soap = this.getSoapSession(connectionCfg);
                    soap.setField(issue, fieldId, value);
                }
            }
            catch (RemoteApiException remoteApiException) {
                throw new JIRAException(e.getMessage(), e);
            }
            throw new JIRAException(e.getMessage(), e);
        }
    }

    @Override
    public void setField(ConnectionCfg connectionCfg, JIRAIssue issue, String fieldId, String[] values) throws JIRAException {
        try {
            JIRASessionPartOne soap = this.getSoapSession(connectionCfg);
            soap.setField(issue, fieldId, values);
        }
        catch (CaptchaRequiredException e) {
            this.removeRssSession(connectionCfg);
            throw new JiraCaptchaRequiredException(e.getMessage());
        }
        catch (RemoteApiException e) {
            this.soapSessions.remove(this.getSessionKey(connectionCfg));
            try {
                if (e != null && e.getMessage().contains("User not authenticated yet, or session timed out.")) {
                    JIRASessionPartOne soap = this.getSoapSession(connectionCfg);
                    soap.setField(issue, fieldId, values);
                }
            }
            catch (RemoteApiException remoteApiException) {
                throw new JIRAException(e.getMessage(), e);
            }
            throw new JIRAException(e.getMessage(), e);
        }
    }

    @Override
    public void setFields(ConnectionCfg connectionCfg, JIRAIssue issue, List<JIRAActionField> fields) throws JIRAException {
        try {
            JIRASessionPartOne soap = this.getSoapSession(connectionCfg);
            soap.setFields(issue, fields);
        }
        catch (CaptchaRequiredException e) {
            this.removeRssSession(connectionCfg);
            throw new JiraCaptchaRequiredException(e.getMessage());
        }
        catch (RemoteApiException e) {
            this.soapSessions.remove(this.getSessionKey(connectionCfg));
            try {
                if (e != null && e.getMessage().contains("User not authenticated yet, or session timed out.")) {
                    JIRASessionPartOne soap = this.getSoapSession(connectionCfg);
                    soap.setFields(issue, fields);
                }
            }
            catch (RemoteApiException remoteApiException) {
                throw new JIRAException(e.getMessage(), e);
            }
            throw new JIRAException(e.getMessage(), e);
        }
    }

    @Override
    public List<JIRAComment> getComments(ConnectionCfg connectionCfg, JIRAIssue issue) throws JIRAException {
        try {
            JIRASessionPartOne soap = this.getSoapSession(connectionCfg);
            return soap.getComments(issue);
        }
        catch (CaptchaRequiredException e) {
            this.removeRssSession(connectionCfg);
            throw new JiraCaptchaRequiredException(e.getMessage());
        }
        catch (RemoteApiException e) {
            this.soapSessions.remove(this.getSessionKey(connectionCfg));
            try {
                if (e != null && e.getMessage().contains("User not authenticated yet, or session timed out.")) {
                    JIRASessionPartOne soap = this.getSoapSession(connectionCfg);
                    return soap.getComments(issue);
                }
            }
            catch (RemoteApiException remoteApiException) {
                throw new JIRAException(e.getMessage(), e);
            }
            throw new JIRAException(e.getMessage(), e);
        }
    }

    @Override
    public Collection<JIRAAttachment> getIssueAttachements(ConnectionCfg connectionCfg, JIRAIssue issue) throws JIRAException {
        try {
            JIRASessionPartOne soap = this.getSoapSession(connectionCfg);
            return soap.getIssueAttachements(issue);
        }
        catch (CaptchaRequiredException e) {
            this.removeRssSession(connectionCfg);
            throw new JiraCaptchaRequiredException(e.getMessage());
        }
        catch (RemoteApiException e) {
            this.soapSessions.remove(this.getSessionKey(connectionCfg));
            try {
                if (e != null && e.getMessage().contains("User not authenticated yet, or session timed out.")) {
                    JIRASessionPartOne soap = this.getSoapSession(connectionCfg);
                    return soap.getIssueAttachements(issue);
                }
            }
            catch (RemoteApiException remoteApiException) {
                throw new JIRAException(e.getMessage(), e);
            }
            throw new JIRAException(e.getMessage(), e);
        }
    }

    @Override
    public void progressWorkflowAction(ConnectionCfg connectionCfg, JIRAIssue issue, JIRAAction action) throws JIRAException {
        this.progressWorkflowAction(connectionCfg, issue, action, null);
    }

    @Override
    public void progressWorkflowAction(ConnectionCfg connectionCfg, JIRAIssue issue, JIRAAction action, List<JIRAActionField> fields) throws JIRAException {
        try {
            JIRASessionPartOne soap = this.getSoapSession(connectionCfg);
            soap.progressWorkflowAction(issue, action, fields);
        }
        catch (CaptchaRequiredException e) {
            this.removeRssSession(connectionCfg);
            throw new JiraCaptchaRequiredException(e.getMessage());
        }
        catch (RemoteApiException e) {
            this.soapSessions.remove(this.getSessionKey(connectionCfg));
            try {
                if (e != null && e.getMessage().contains("User not authenticated yet, or session timed out.")) {
                    JIRASessionPartOne soap = this.getSoapSession(connectionCfg);
                    soap.progressWorkflowAction(issue, action, fields);
                }
            }
            catch (RemoteApiException remoteApiException) {
                throw new JIRAException(e.getMessage(), e);
            }
            throw new JIRAException(e.getMessage(), e);
        }
    }

    @Override
    public JIRAIssue getIssueDetails(ConnectionCfg connectionCfg, JIRAIssue issue) throws JIRAException {
        try {
            JIRASessionPartOne soap = this.getSoapSession(connectionCfg);
            return soap.getIssueDetails(issue);
        }
        catch (CaptchaRequiredException e) {
            this.removeRssSession(connectionCfg);
            throw new JiraCaptchaRequiredException(e.getMessage());
        }
        catch (RemoteApiException e) {
            this.soapSessions.remove(this.getSessionKey(connectionCfg));
            try {
                if (e != null && e.getMessage().contains("User not authenticated yet, or session timed out.")) {
                    JIRASessionPartOne soap = this.getSoapSession(connectionCfg);
                    return soap.getIssueDetails(issue);
                }
            }
            catch (RemoteApiException remoteApiException) {
                throw new JIRAException(e.getMessage(), e);
            }
            throw new JIRAException(e.getMessage(), e);
        }
    }

    @Override
    public JIRAUserBean getUser(ConnectionCfg connectionCfg, String loginName) throws JIRAException, JiraUserNotFoundException {
        try {
            JIRASessionPartOne soap = this.getSoapSession(connectionCfg);
            return soap.getUser(loginName);
        }
        catch (CaptchaRequiredException e) {
            this.removeRssSession(connectionCfg);
            throw new JiraCaptchaRequiredException(e.getMessage());
        }
        catch (RemoteApiException e) {
            this.soapSessions.remove(this.getSessionKey(connectionCfg));
            try {
                if (e != null && e.getMessage().contains("User not authenticated yet, or session timed out.")) {
                    JIRASessionPartOne soap = this.getSoapSession(connectionCfg);
                    return soap.getUser(loginName);
                }
            }
            catch (RemoteApiException remoteApiException) {
                throw new JIRAException(e.getMessage(), e);
            }
            throw new JIRAException(e.getMessage(), e);
        }
    }

    @Override
    public List<JIRASecurityLevelBean> getSecurityLevels(ConnectionCfg connectionCfg, String projectKey) throws JIRAException {
        try {
            JIRASessionPartOne soap = this.getSoapSession(connectionCfg);
            return soap.getSecurityLevels(projectKey);
        }
        catch (CaptchaRequiredException e) {
            this.removeRssSession(connectionCfg);
            throw new JiraCaptchaRequiredException(e.getMessage());
        }
        catch (RemoteApiException e) {
            this.soapSessions.remove(this.getSessionKey(connectionCfg));
            try {
                if (e != null && e.getMessage().contains("User not authenticated yet, or session timed out.")) {
                    JIRASessionPartOne soap = this.getSoapSession(connectionCfg);
                    return soap.getSecurityLevels(projectKey);
                }
            }
            catch (RemoteApiException remoteApiException) {
                throw new JIRAException(e.getMessage(), e);
            }
            throw new JIRAException(e.getMessage(), e);
        }
    }
}

