/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.properties;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.springframework.ide.eclipse.webflow.core.model.IAction;
import org.springframework.ide.eclipse.webflow.core.model.ICloneableModelElement;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.springframework.ide.eclipse.webflow.ui.graph.actions.EditPropertiesAction;
import org.springframework.ide.eclipse.webflow.ui.graph.commands.EditPropertiesCommand;
import org.springframework.ide.eclipse.webflow.ui.graph.parts.AbstractStatePart;

public class ActionNameSection
extends AbstractPropertySection
implements PropertyChangeListener {
    private Text labelText;
    private IAction action;
    private IAction oldAction;
    private ModifyListener listener = new ModifyListener(){

        public void modifyText(ModifyEvent arg0) {
            IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            ActionRegistry actionRegistry = (ActionRegistry)editor.getAdapter(ActionRegistry.class);
            EditPropertiesAction editAction = (EditPropertiesAction)actionRegistry.getAction((Object)"Edit_propeties");
            editAction.setOpenDialog(false);
            EditPropertiesCommand command = new EditPropertiesCommand();
            IAction clone = null;
            if (ActionNameSection.this.action instanceof ICloneableModelElement) {
                clone = (IAction)((ICloneableModelElement)ActionNameSection.this.action).cloneModelElement();
            }
            clone.setName(ActionNameSection.this.labelText.getText());
            command.setChild((ICloneableModelElement<IWebflowModelElement>)((ICloneableModelElement)ActionNameSection.this.action), (IWebflowModelElement)clone);
            if (editAction != null) {
                ActionNameSection.this.action.removePropertyChangeListener((PropertyChangeListener)ActionNameSection.this);
                editAction.runWithCommand(command);
                ActionNameSection.this.action.addPropertyChangeListener((PropertyChangeListener)ActionNameSection.this);
            }
        }
    };

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        this.labelText = this.getWidgetFactory().createText(composite, "");
        FormData data = new FormData();
        data.left = new FormAttachment(0, 85);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        this.labelText.setLayoutData((Object)data);
        this.labelText.addModifyListener(this.listener);
        CLabel labelLabel = this.getWidgetFactory().createCLabel(composite, "Name:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.labelText, -5);
        data.top = new FormAttachment((Control)this.labelText, 0, 0x1000000);
        labelLabel.setLayoutData((Object)data);
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        Assert.isTrue((boolean)(selection instanceof IStructuredSelection));
        Object input = ((IStructuredSelection)selection).getFirstElement();
        if (this.oldAction != null) {
            this.oldAction.removePropertyChangeListener((PropertyChangeListener)this);
        }
        if (input instanceof AbstractStatePart && ((AbstractStatePart)input).getModel() instanceof IAction) {
            this.action = (IAction)((AbstractStatePart)input).getModel();
            this.action.addPropertyChangeListener((PropertyChangeListener)this);
            this.oldAction = this.action;
        }
    }

    public void refresh() {
        this.labelText.removeModifyListener(this.listener);
        if (this.action != null && this.action.getName() != null) {
            this.labelText.setText(this.action.getName());
        } else {
            this.labelText.setText("");
        }
        this.labelText.addModifyListener(this.listener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.refresh();
    }

    public void dispose() {
        if (this.action != null) {
            this.action.removePropertyChangeListener((PropertyChangeListener)this);
        }
        super.dispose();
    }
}

