/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.commands;

import org.eclipse.gef.commands.Command;
import org.springframework.ide.eclipse.webflow.core.internal.model.StateTransition;
import org.springframework.ide.eclipse.webflow.core.model.IState;
import org.springframework.ide.eclipse.webflow.core.model.IStateTransition;
import org.springframework.ide.eclipse.webflow.core.model.ITransition;
import org.springframework.ide.eclipse.webflow.core.model.ITransitionableFrom;
import org.springframework.ide.eclipse.webflow.core.model.ITransitionableTo;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowState;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.DialogUtils;

public class SplitStateTransitionCommand
extends Command {
    private int index;
    private IState newActivity;
    private IStateTransition newTransition;
    private ITransitionableFrom oldSource;
    private ITransitionableTo oldTarget;
    private IWebflowState parent;
    private IStateTransition oldTransition;

    public void execute() {
        this.newActivity.createNew(this.parent);
        int result = DialogUtils.openPropertiesDialog((IWebflowModelElement)this.parent, (IWebflowModelElement)this.newActivity, true);
        if (result != 0) {
            return;
        }
        this.index = this.parent.getStates().indexOf(this.oldSource) + 1;
        this.parent.addState(this.newActivity, this.index);
        this.oldTarget.removeInputTransition((ITransition)this.oldTransition);
        this.oldTransition.setToState((ITransitionableTo)this.newActivity);
        this.newTransition = new StateTransition();
        this.newTransition.createNew((IWebflowModelElement)this.newActivity, (IWebflowState)this.newActivity.getElementParent());
        this.newTransition.setOn("*");
        this.newTransition.setFromState((ITransitionableFrom)this.newActivity);
        this.newTransition.setToState(this.oldTarget);
        ((ITransitionableFrom)this.newActivity).addOutputTransition((ITransition)this.newTransition);
    }

    public void redo() {
        this.parent.addState(this.newActivity, this.index);
        this.oldTarget.removeInputTransition((ITransition)this.oldTransition);
        this.oldTransition.setToState((ITransitionableTo)this.newActivity);
        this.newTransition = new StateTransition();
        this.newTransition.createNew((IWebflowModelElement)this.newActivity, (IWebflowState)this.newActivity.getElementParent());
        this.newTransition.setOn("*");
        this.newTransition.setFromState((ITransitionableFrom)this.newActivity);
        this.newTransition.setToState(this.oldTarget);
        ((ITransitionableFrom)this.newActivity).addOutputTransition((ITransition)this.newTransition);
    }

    public void setNewActivity(IState activity) {
        this.newActivity = activity;
    }

    public void setParent(IWebflowState activity) {
        this.parent = activity;
    }

    public void setTransition(IStateTransition transition) {
        this.oldTransition = transition;
        this.oldSource = transition.getFromState();
        this.oldTarget = transition.getToState();
    }

    public void undo() {
        ((ITransitionableTo)this.newActivity).removeInputTransition((ITransition)this.oldTransition);
        this.oldTransition.setToState(this.oldTarget);
        this.oldTarget.removeInputTransition((ITransition)this.newTransition);
        ((ITransitionableFrom)this.newActivity).removeOutputTransition((ITransition)this.newTransition);
        this.parent.removeState(this.newActivity);
    }
}

