/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.commands;

import org.eclipse.gef.commands.Command;
import org.springframework.ide.eclipse.webflow.core.internal.model.Action;
import org.springframework.ide.eclipse.webflow.core.internal.model.BeanAction;
import org.springframework.ide.eclipse.webflow.core.internal.model.EvaluateAction;
import org.springframework.ide.eclipse.webflow.core.internal.model.Set;
import org.springframework.ide.eclipse.webflow.core.model.IActionElement;
import org.springframework.ide.eclipse.webflow.core.model.IStateTransition;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.DialogUtils;

public class AddTransitionActionCommand
extends Command {
    private IActionElement child;
    private IStateTransition parent;

    public void execute() {
        if (this.child instanceof Action) {
            ((Action)this.child).createNew((IWebflowModelElement)this.parent);
        } else if (this.child instanceof BeanAction) {
            ((BeanAction)this.child).createNew((IWebflowModelElement)this.parent);
        } else if (this.child instanceof EvaluateAction) {
            ((EvaluateAction)this.child).createNew((IWebflowModelElement)this.parent);
        } else if (this.child instanceof Set) {
            ((Set)this.child).createNew((IWebflowModelElement)this.parent);
        }
        if (DialogUtils.openPropertiesDialog(null, (IWebflowModelElement)this.child, true) != 0) {
            return;
        }
        if (this.child.getType() == IActionElement.ACTION_TYPE.ACTION) {
            this.parent.addAction(this.child);
        }
    }

    public void redo() {
        this.parent.addAction(this.child);
    }

    public void setNewAction(IActionElement activity) {
        this.child = activity;
    }

    public void setTransition(IStateTransition transition) {
        this.parent = transition;
    }

    public void undo() {
        this.parent.removeAction(this.child);
    }
}

