/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.refactoring.jdt;

import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.springframework.ide.eclipse.beans.ui.refactoring.jdt.AbstractRenameRefactoringParticipant;
import org.springframework.ide.eclipse.beans.ui.refactoring.util.BeansRefactoringChangeUtils;
import org.springframework.ide.eclipse.core.SpringCoreUtils;
import org.springframework.util.StringUtils;

public class BeansMethodRenameRefactoringParticipant
extends AbstractRenameRefactoringParticipant {
    protected boolean initialize(Object element) {
        if (element instanceof IMethod) {
            IMethod method = (IMethod)element;
            IJavaProject javaProject = (IJavaProject)method.getAncestor(2);
            this.project = javaProject.getProject();
            if (SpringCoreUtils.isSpringProject((IResource)this.project)) {
                this.elements = new HashMap();
                this.elements.put(method, this.getArguments().getNewName());
                return true;
            }
        }
        return false;
    }

    @Override
    protected void addChange(CompositeChange result, IResource resource, IProgressMonitor pm) throws CoreException {
        Change change;
        if (resource.exists() && (change = BeansRefactoringChangeUtils.createMethodRenameChange((IFile)resource, this.getAffectedElements(), this.getNewNames(), pm)) != null) {
            result.add(change);
        }
    }

    private String[] getNewNames() {
        String[] result = new String[this.elements.size()];
        int i = 0;
        while (i < this.elements.size()) {
            String newName = this.getArguments().getNewName();
            if (newName.startsWith("set")) {
                newName = StringUtils.uncapitalize((String)newName.substring(3));
            }
            result[i] = newName;
            ++i;
        }
        return result;
    }

    @Override
    public String getName() {
        return "Rename properties referenced in Spring Bean definitions";
    }
}

