/*
 * Decompiled with CFR 0.152.
 */
package com.collabnet.subversion.merge;

import com.collabnet.subversion.merge.MergeOutput;
import com.collabnet.subversion.merge.MergeResult;
import com.collabnet.subversion.merge.Messages;
import com.collabnet.subversion.merge.SVNConflictResolver;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class MergeResultsFolder
implements IPropertySource {
    private IContainer folder;
    private boolean compressed;
    private int rootFolderLength;
    private MergeOutput mergeOutput;
    private MergeResult mergeResult;
    public static String P_ID_RESOURCE = "resource";
    public static String P_RESOURCE = Messages.MergeResultsFolder_resource;
    public static String P_ID_TEXT_STATUS = "textSts";
    public static String P_TEXT_STATUS = Messages.MergeResultsFolder_textStatus;
    public static String P_ID_PROPERTY_STATUS = "propSts";
    public static String P_PROPERTY_STATUS = Messages.MergeResultsFolder_propsStatus;
    public static List descriptors = new ArrayList();

    static {
        descriptors.add(new PropertyDescriptor((Object)P_ID_RESOURCE, P_RESOURCE));
        descriptors.add(new PropertyDescriptor((Object)P_ID_TEXT_STATUS, P_TEXT_STATUS));
        descriptors.add(new PropertyDescriptor((Object)P_ID_PROPERTY_STATUS, P_PROPERTY_STATUS));
    }

    public IContainer getFolder() {
        return this.folder;
    }

    public void setFolder(IContainer folder) {
        this.folder = folder;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public void setCompressed(boolean compressed) {
        this.compressed = compressed;
    }

    public void setRootFolderLength(int rootFolderLength) {
        this.rootFolderLength = rootFolderLength;
    }

    public String toString() {
        if (this.compressed) {
            if (this.folder.getFullPath().makeRelative().toString().length() > this.rootFolderLength) {
                return this.folder.getFullPath().makeRelative().toString().substring(this.rootFolderLength + 1);
            }
            return this.mergeOutput.getResource().getName();
        }
        return this.folder.getName();
    }

    public MergeOutput getMergeOutput() {
        return this.mergeOutput;
    }

    public void setMergeOutput(MergeOutput mergeOutput) {
        this.mergeOutput = mergeOutput;
    }

    public MergeResult[] getMergeResults(boolean conflictsOnly) {
        MergeResult[] mergeResults = this.mergeOutput.getMergeResults(conflictsOnly);
        ArrayList<MergeResult> mergeResultList = new ArrayList<MergeResult>();
        boolean resultAdded = false;
        int i = 0;
        while (i < mergeResults.length) {
            if (mergeResults[i].getResource() instanceof IFile) {
                IContainer parent = mergeResults[i].getResource().getParent();
                if (parent.getFullPath().toString().equals(this.folder.getFullPath().toString())) {
                    mergeResultList.add(mergeResults[i]);
                    resultAdded = true;
                } else if (resultAdded) break;
            }
            ++i;
        }
        MergeResult[] mergeResultArray = new MergeResult[mergeResultList.size()];
        mergeResultList.toArray(mergeResultArray);
        return mergeResultArray;
    }

    public MergeResult getMergeResult() {
        return this.mergeResult;
    }

    public void setMergeResult(MergeResult mergeResult) {
        this.mergeResult = mergeResult;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MergeResultsFolder) {
            MergeResultsFolder compareFolder = (MergeResultsFolder)obj;
            return compareFolder.getFolder().getFullPath().toString().equals(this.folder.getFullPath().toString());
        }
        if (obj instanceof IContainer) {
            IContainer compareFolder = (IContainer)obj;
            return compareFolder.getFullPath().toString().equals(this.folder.getFullPath().toString());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.folder.getFullPath().toString().hashCode();
    }

    public int getRootFolderLength() {
        return this.rootFolderLength;
    }

    public Object getEditableValue() {
        return this.folder.getFullPath().toString();
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return MergeResultsFolder.getDescriptors().toArray(new IPropertyDescriptor[MergeResultsFolder.getDescriptors().size()]);
    }

    private static List getDescriptors() {
        return descriptors;
    }

    public Object getPropertyValue(Object id) {
        if (P_ID_RESOURCE.equals(id)) {
            return this.folder.getFullPath().toString();
        }
        if (this.mergeResult == null) {
            return Messages.MergeResultsFolder_noChange;
        }
        if (P_ID_TEXT_STATUS.equals(id)) {
            if (this.mergeResult.getAction().equals("A")) {
                return Messages.MergeResultsFolder_added;
            }
            if (this.mergeResult.getAction().equals("U")) {
                return Messages.MergeResultsFolder_modified;
            }
            if (this.mergeResult.getAction().equals("D")) {
                return Messages.MergeResultsFolder_deleted;
            }
            if (this.mergeResult.getAction().equals("G")) {
                return Messages.MergeResultsFolder_merged;
            }
            if (this.mergeResult.getAction().equals("S")) {
                return Messages.MergeResultsFolder_skipped;
            }
            if (this.mergeResult.getAction().equals("C")) {
                if (this.mergeResult.isResolved()) {
                    return String.valueOf(Messages.MergeResultsFolder_resolvedConflict) + SVNConflictResolver.getResolutionDescription(this.mergeResult.getConflictResolution()) + ")";
                }
                return Messages.MergeResultsFolder_conflicted;
            }
        }
        if (P_ID_PROPERTY_STATUS.equals(id)) {
            if (this.mergeResult.getPropertyAction().equals("A")) {
                return Messages.MergeResultsFolder_added;
            }
            if (this.mergeResult.getPropertyAction().equals("U")) {
                return Messages.MergeResultsFolder_modified;
            }
            if (this.mergeResult.getPropertyAction().equals("D")) {
                return Messages.MergeResultsFolder_deleted;
            }
            if (this.mergeResult.getPropertyAction().equals("G")) {
                return Messages.MergeResultsFolder_merged;
            }
            if (this.mergeResult.getPropertyAction().equals("S")) {
                return Messages.MergeResultsFolder_skipped;
            }
            if (this.mergeResult.getPropertyAction().equals("C")) {
                if (this.mergeResult.isPropertyResolved()) {
                    return String.valueOf(Messages.MergeResultsFolder_resolvedConflict) + SVNConflictResolver.getResolutionDescription(this.mergeResult.getPropertyResolution()) + ")";
                }
                return Messages.MergeResultsFolder_conflicted;
            }
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }
}

