/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.mock;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.core.Headers;
import org.jboss.resteasy.plugins.providers.FormUrlEncodedProvider;
import org.jboss.resteasy.specimpl.HttpHeadersImpl;
import org.jboss.resteasy.specimpl.MultivaluedMapImpl;
import org.jboss.resteasy.specimpl.PathSegmentImpl;
import org.jboss.resteasy.specimpl.UriInfoImpl;
import org.jboss.resteasy.spi.AsynchronousResponse;
import org.jboss.resteasy.spi.BadRequestException;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.util.Encode;
import org.jboss.resteasy.util.LocaleHelper;
import org.jboss.resteasy.util.ReadFromStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockHttpRequest
implements HttpRequest {
    protected HttpHeadersImpl httpHeaders;
    protected InputStream inputStream;
    protected UriInfo uri;
    protected String httpMethod;
    protected String preprocessedPath;
    protected MultivaluedMap<String, String> formParameters;
    protected MultivaluedMap<String, String> decodedFormParameters;
    protected Map<String, Object> attributes = new HashMap<String, Object>();

    protected MockHttpRequest() {
    }

    protected static MockHttpRequest initWithUri(String uri) throws URISyntaxException {
        URI absoluteUri;
        URI baseUri = absoluteUri = new URI(uri);
        return MockHttpRequest.initWithUri(absoluteUri, baseUri);
    }

    private static MockHttpRequest initWithUri(URI absoluteUri, URI baseUri) {
        MockHttpRequest request = new MockHttpRequest();
        request.httpHeaders = new HttpHeadersImpl();
        request.httpHeaders.setAcceptableLanguages(new ArrayList<String>());
        request.httpHeaders.setAcceptableMediaTypes(new ArrayList<MediaType>());
        request.httpHeaders.setCookies(new HashMap<String, Cookie>());
        request.httpHeaders.setRequestHeaders(new Headers<String>());
        request.uri = new UriInfoImpl(absoluteUri, baseUri, absoluteUri.getRawPath(), absoluteUri.getRawQuery(), PathSegmentImpl.parseSegments(absoluteUri.getRawPath()));
        request.preprocessedPath = request.uri.getPath(false);
        return request;
    }

    public static MockHttpRequest create(String httpMethod, String uri) throws URISyntaxException {
        MockHttpRequest request = MockHttpRequest.initWithUri(uri);
        request.httpMethod = httpMethod;
        return request;
    }

    public static MockHttpRequest create(String httpMethod, URI uriObj, URI baseUri) {
        MockHttpRequest request = MockHttpRequest.initWithUri(uriObj, baseUri);
        request.httpMethod = httpMethod;
        return request;
    }

    public static MockHttpRequest get(String uri) throws URISyntaxException {
        MockHttpRequest request = MockHttpRequest.initWithUri(uri);
        request.httpMethod = "GET";
        return request;
    }

    public static MockHttpRequest post(String uri) throws URISyntaxException {
        MockHttpRequest request = MockHttpRequest.initWithUri(uri);
        request.httpMethod = "POST";
        return request;
    }

    public static MockHttpRequest put(String uri) throws URISyntaxException {
        MockHttpRequest request = MockHttpRequest.initWithUri(uri);
        request.httpMethod = "PUT";
        return request;
    }

    public static MockHttpRequest delete(String uri) throws URISyntaxException {
        MockHttpRequest request = MockHttpRequest.initWithUri(uri);
        request.httpMethod = "DELETE";
        return request;
    }

    public static MockHttpRequest head(String uri) throws URISyntaxException {
        MockHttpRequest request = MockHttpRequest.initWithUri(uri);
        request.httpMethod = "HEAD";
        return request;
    }

    public static MockHttpRequest deepCopy(HttpRequest request) throws IOException {
        MockHttpRequest mock = new MockHttpRequest();
        mock.uri = request.getUri();
        mock.httpHeaders = (HttpHeadersImpl)request.getHttpHeaders();
        mock.httpMethod = request.getHttpMethod();
        mock.inputStream = new ByteArrayInputStream(ReadFromStream.readFromStream(1024, request.getInputStream()));
        mock.preprocessedPath = request.getPreprocessedPath();
        return mock;
    }

    public MockHttpRequest header(String name, String value) {
        this.httpHeaders.getRequestHeaders().add((Object)name, (Object)value);
        return this;
    }

    public MockHttpRequest accept(List<MediaType> accepts) {
        this.httpHeaders.setAcceptableMediaTypes(accepts);
        return this;
    }

    public MockHttpRequest accept(String type) {
        this.httpHeaders.getRequestHeaders().add((Object)"Accept", (Object)type);
        this.httpHeaders.getAcceptableMediaTypes().add(MediaType.valueOf((String)type));
        return this;
    }

    public MockHttpRequest language(String language) {
        this.httpHeaders.getRequestHeaders().add((Object)"Accept-Language", (Object)language);
        this.httpHeaders.getAcceptableLanguages().add(LocaleHelper.extractLocale(language));
        return this;
    }

    public MockHttpRequest cookie(String name, String value) {
        Cookie cookie = new Cookie(name, value);
        this.httpHeaders.getCookies().put(name, cookie);
        return this;
    }

    public MockHttpRequest contentType(String type) {
        this.httpHeaders.getRequestHeaders().add((Object)"Content-Type", (Object)type);
        this.httpHeaders.setMediaType(MediaType.valueOf((String)type));
        return this;
    }

    public MockHttpRequest contentType(MediaType type) {
        this.httpHeaders.getRequestHeaders().add((Object)"Content-Type", (Object)type.toString());
        this.httpHeaders.setMediaType(type);
        return this;
    }

    public MockHttpRequest content(byte[] bytes) {
        this.inputStream = new ByteArrayInputStream(bytes);
        return this;
    }

    public MockHttpRequest content(InputStream stream) {
        this.inputStream = stream;
        return this;
    }

    public MockHttpRequest addFormHeader(String name, String value) {
        if (this.decodedFormParameters == null) {
            this.decodedFormParameters = new MultivaluedMapImpl<String, String>();
            this.contentType("application/x-www-form-urlencoded");
        }
        this.decodedFormParameters.add((Object)name, (Object)value);
        return this;
    }

    @Override
    public HttpHeaders getHttpHeaders() {
        return this.httpHeaders;
    }

    @Override
    public InputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    public void setInputStream(InputStream stream) {
        this.inputStream = stream;
    }

    @Override
    public UriInfo getUri() {
        return this.uri;
    }

    @Override
    public String getHttpMethod() {
        return this.httpMethod;
    }

    @Override
    public MultivaluedMap<String, String> getFormParameters() {
        if (this.formParameters != null) {
            return this.formParameters;
        }
        if (this.decodedFormParameters != null) {
            this.formParameters = Encode.encode(this.decodedFormParameters);
            return this.formParameters;
        }
        if (this.getHttpHeaders().getMediaType().isCompatible(MediaType.valueOf((String)"application/x-www-form-urlencoded"))) {
            try {
                this.formParameters = FormUrlEncodedProvider.parseForm(this.getInputStream());
            }
            catch (IOException e) {
                throw new BadRequestException(e);
            }
        } else {
            throw new IllegalArgumentException("Request media type is not application/x-www-form-urlencoded");
        }
        return this.formParameters;
    }

    @Override
    public MultivaluedMap<String, String> getDecodedFormParameters() {
        if (this.decodedFormParameters != null) {
            return this.decodedFormParameters;
        }
        this.decodedFormParameters = Encode.decode(this.getFormParameters());
        return this.decodedFormParameters;
    }

    @Override
    public String getPreprocessedPath() {
        return this.preprocessedPath;
    }

    @Override
    public void setPreprocessedPath(String path) {
        this.preprocessedPath = path;
    }

    public void suspend() {
        throw new UnsupportedOperationException();
    }

    public void suspend(long timeout) {
        throw new UnsupportedOperationException();
    }

    public void complete() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isInitial() {
        return true;
    }

    @Override
    public boolean isSuspended() {
        return false;
    }

    public boolean isTimeout() {
        return false;
    }

    @Override
    public AsynchronousResponse createAsynchronousResponse(long suspendTimeout) {
        throw new UnsupportedOperationException("NOT SUPPORTED");
    }

    @Override
    public AsynchronousResponse getAsynchronousResponse() {
        throw new UnsupportedOperationException("NOT SUPPORTED");
    }

    @Override
    public void initialRequestThreadFinished() {
    }

    @Override
    public Object getAttribute(String attribute) {
        return this.attributes.get(attribute);
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    @Override
    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }
}

