/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.skin;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.ajax4jsf.Messages;
import org.ajax4jsf.resource.util.URLToStreamHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.richfaces.skin.Skin;
import org.richfaces.skin.Theme;

public abstract class SkinFactory {
    private static Map<ClassLoader, SkinFactory> instances = Collections.synchronizedMap(new HashMap());
    private static final Log log = LogFactory.getLog(SkinFactory.class);
    public static final String SERVICE_RESOURCE = "META-INF/services/" + SkinFactory.class.getName();
    public static final String SKIN_PARAMETER = "org.richfaces.SKIN";
    public static final String BASE_SKIN_PARAMETER = "org.richfaces.BASE_SKIN";
    public static final String DEFAULT_SKIN_FACTORY_IMPL_CLASS = "org.richfaces.skin.SkinFactoryImpl";

    public static void reset() {
        instances = Collections.synchronizedMap(new HashMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final SkinFactory getInstance() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        SkinFactory instance = instances.get(loader);
        if (instance == null) {
            InputStream input = null;
            input = URLToStreamHelper.urlToStreamSafe(loader.getResource(SERVICE_RESOURCE));
            if (input != null) {
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(input));
                    String factoryClassName = reader.readLine();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)Messages.getMessage("SET_SKIN_FACTORY_INFO", factoryClassName));
                    }
                    instance = SkinFactory.instantiateSkinFactory(factoryClassName, loader);
                }
                catch (Exception e) {
                    log.warn((Object)Messages.getMessage("CREATING_SKIN_FACTORY_ERROR"), (Throwable)e);
                }
                finally {
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            if (instance == null) {
                instance = SkinFactory.instantiateSkinFactory(DEFAULT_SKIN_FACTORY_IMPL_CLASS, loader);
            }
            instances.put(loader, instance);
        }
        return instance;
    }

    private static SkinFactory instantiateSkinFactory(String factoryClassName, ClassLoader classLoader) throws FacesException {
        SkinFactory instance = null;
        try {
            Class<?> clazz = Class.forName(factoryClassName, false, classLoader);
            try {
                Constructor<?> factoryConstructor = clazz.getConstructor(SkinFactory.class);
                instance = (SkinFactory)factoryConstructor.newInstance(instance);
            }
            catch (NoSuchMethodException e) {
                instance = (SkinFactory)clazz.newInstance();
            }
        }
        catch (InvocationTargetException ite) {
            log.error((Object)Messages.getMessage("CREATING_SKIN_FACTORY_ERROR"), (Throwable)ite);
            throw new FacesException("Exception when creating instance of [" + SkinFactory.class.getName() + "]", (Throwable)ite);
        }
        catch (InstantiationException ie) {
            log.error((Object)Messages.getMessage("CREATING_SKIN_FACTORY_ERROR"), (Throwable)ie);
            throw new FacesException("Exception when creating instance of [" + SkinFactory.class.getName() + "]", (Throwable)ie);
        }
        catch (IllegalAccessException iae) {
            log.error((Object)Messages.getMessage("CREATING_SKIN_FACTORY_ERROR"), (Throwable)iae);
            throw new FacesException("Exception when creating instance of [" + SkinFactory.class.getName() + "]", (Throwable)iae);
        }
        catch (ClassNotFoundException cnfe) {
            log.error((Object)Messages.getMessage("CREATING_SKIN_FACTORY_ERROR"), (Throwable)cnfe);
            throw new FacesException("Exception when creating instance of [" + SkinFactory.class.getName() + "]", (Throwable)cnfe);
        }
        return instance;
    }

    public abstract Skin getDefaultSkin(FacesContext var1);

    public abstract Skin getSkin(FacesContext var1);

    public abstract Skin getBaseSkin(FacesContext var1);

    public abstract Theme getTheme(FacesContext var1, String var2);
}

