/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.livegraph.actions;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.springframework.ide.eclipse.beans.ui.livegraph.actions.AbstractOpenResourceAction;
import org.springframework.ide.eclipse.beans.ui.livegraph.model.LiveBean;
import org.springframework.ide.eclipse.beans.ui.livegraph.model.LiveBeansSession;
import org.springsource.ide.eclipse.commons.core.StatusHandler;
import org.springsource.ide.eclipse.commons.ui.SpringUIUtils;

public class OpenBeanDefinitionAction
extends AbstractOpenResourceAction {
    public OpenBeanDefinitionAction() {
        super("Open Bean Definition File");
    }

    private void openXmlFiles(List<String> contexts, LiveBeansSession session) {
        try {
            IProject[] projects;
            IProject[] iProjectArray = projects = this.findProjects(session);
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                IPath[] paths = ResourceUtils.getAllJavaSourceLocations((IProject)project);
                if (paths.length > 0) {
                    IPath[] iPathArray = paths;
                    int n3 = paths.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IPath path = iPathArray[n4];
                        IResource resource = ResourceUtils.findResource((IPath)path);
                        if (resource.exists()) {
                            resource.accept((IResourceProxyVisitor)new ResourceProxyVisitor(contexts), 4);
                        }
                        ++n4;
                    }
                } else {
                    project.accept((IResourceProxyVisitor)new ResourceProxyVisitor(contexts), 4);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            StatusHandler.log((IStatus)new Status(4, "org.springframework.ide.eclipse.beans.ui.livegraph", "An error occurred while attempting to open an application context file.", (Throwable)e));
        }
    }

    public void run() {
        IStructuredSelection selection = this.getStructuredSelection();
        List elements = selection.toList();
        LiveBeansSession session = null;
        ArrayList<String> contexts = new ArrayList<String>();
        for (Object obj : elements) {
            if (!(obj instanceof LiveBean)) continue;
            LiveBean bean = (LiveBean)obj;
            session = bean.getSession();
            String resource = bean.getResource();
            if (resource == null || resource.trim().length() <= 0 || resource.equalsIgnoreCase("null")) continue;
            String resourcePath = this.extractResourcePath(resource);
            if (resourcePath.endsWith(".xml")) {
                if (!resourcePath.contains(File.separator)) continue;
                int pathSeparator = resourcePath.lastIndexOf(File.separator);
                resourcePath = resourcePath.substring(pathSeparator + 1);
                contexts.add(resourcePath);
                continue;
            }
            if (!resourcePath.endsWith(".class")) continue;
            this.openInEditor(session, this.extractClassName(resourcePath));
        }
        if (session != null) {
            this.openXmlFiles(contexts, session);
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        if (!selection.isEmpty()) {
            List elements = selection.toList();
            for (Object obj : elements) {
                LiveBean bean;
                String resource;
                if (!(obj instanceof LiveBean) || (resource = (bean = (LiveBean)obj).getResource()) == null || resource.trim().length() <= 0 || resource.equalsIgnoreCase("null")) continue;
                return true;
            }
        }
        return false;
    }

    private class ResourceProxyVisitor
    implements IResourceProxyVisitor {
        private final List<String> contexts;

        private ResourceProxyVisitor(List<String> contexts) {
            this.contexts = contexts;
        }

        public boolean visit(IResourceProxy proxy) throws CoreException {
            if (1 == proxy.getType()) {
                for (String appContext : this.contexts) {
                    if (!appContext.equals(proxy.getName().trim())) continue;
                    SpringUIUtils.openInEditor((IFile)((IFile)proxy.requestResource()), (int)0);
                }
                return false;
            }
            return true;
        }
    }
}

