/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.gettingstarted.guides;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.springframework.ide.eclipse.wizard.gettingstarted.content.BuildType;
import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;
import org.springsource.ide.eclipse.commons.livexp.core.LiveVariable;
import org.springsource.ide.eclipse.commons.livexp.core.SelectionModel;
import org.springsource.ide.eclipse.commons.livexp.core.UIValueListener;
import org.springsource.ide.eclipse.commons.livexp.core.ValidationResult;
import org.springsource.ide.eclipse.commons.livexp.core.Validator;
import org.springsource.ide.eclipse.commons.livexp.core.ValueListener;
import org.springsource.ide.eclipse.commons.livexp.ui.GroupSection;
import org.springsource.ide.eclipse.commons.livexp.ui.IPageWithSections;
import org.springsource.ide.eclipse.commons.livexp.ui.WizardPageSection;
import org.springsource.ide.eclipse.commons.livexp.ui.WizardPageWithSections;

public class BuildTypeRadiosSection
extends GroupSection {
    private final SelectionModel<BuildType> selection;

    protected GridLayout createLayout() {
        return new GridLayout(3, true);
    }

    public BuildTypeRadiosSection(WizardPageWithSections owner, SelectionModel<BuildType> selection) {
        super(owner, "Build Type", BuildTypeRadiosSection.createSections(owner, selection));
        this.selection = selection;
    }

    private static WizardPageSection[] createSections(WizardPageWithSections owner, SelectionModel<BuildType> selection) {
        BuildType[] types = BuildType.values();
        WizardPageSection[] section = new WizardPageSection[types.length];
        int i = 0;
        while (i < section.length) {
            section[i] = new BuildTypeChoice((IPageWithSections)owner, types[i], (LiveVariable<BuildType>)selection.selection);
            ++i;
        }
        return section;
    }

    public LiveExpression<ValidationResult> getValidator() {
        return this.selection.validator;
    }

    private static class BuildTypeChoice
    extends WizardPageSection {
        private final BuildType type;
        private final LiveVariable<BuildType> selection;

        public BuildTypeChoice(IPageWithSections owner, BuildType buildType, LiveVariable<BuildType> selection) {
            super(owner);
            this.type = buildType;
            this.selection = selection;
        }

        public LiveExpression<ValidationResult> getValidator() {
            return Validator.constant((Object)ValidationResult.OK);
        }

        public void createContents(Composite page) {
            final Button button = new Button(page, 16);
            button.setText(this.type.displayName());
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)button);
            this.selection.addListener((ValueListener)new UIValueListener<BuildType>(){

                protected void uiGotValue(LiveExpression<BuildType> exp, BuildType value) {
                    button.setSelection(value == BuildTypeChoice.this.type);
                }
            });
            button.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (button.getSelection()) {
                        BuildTypeChoice.this.selection.setValue((Object)BuildTypeChoice.this.type);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    if (button.getSelection()) {
                        BuildTypeChoice.this.selection.setValue((Object)BuildTypeChoice.this.type);
                    }
                }
            });
        }
    }
}

