/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.frameworks.ui.internal.utils;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IFileEditorInput;
import org.springsource.ide.eclipse.commons.frameworks.core.FrameworkCoreActivator;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.utils.ProjectFilter;
import org.springsource.ide.eclipse.commons.ui.SpringUIUtils;

public class SelectionUtils {
    public static List<IProject> getProjects(ISelection selection, ProjectFilter filter) {
        LinkedHashSet<IProject> selected = new LinkedHashSet<IProject>();
        if (selection instanceof IStructuredSelection) {
            for (Object obj : (IStructuredSelection)selection) {
                IResource resource = null;
                if (obj instanceof IResource) {
                    resource = (IResource)obj;
                } else if (obj instanceof IAdaptable) {
                    resource = (IResource)((IAdaptable)obj).getAdapter(IResource.class);
                }
                if (resource == null || !filter.isAcceptable(resource.getProject())) continue;
                selected.add(resource.getProject());
            }
        } else if (SpringUIUtils.getActiveEditor() != null && SpringUIUtils.getActiveEditor().getEditorInput() instanceof IFileEditorInput) {
            selected.add(((IFileEditorInput)SpringUIUtils.getActiveEditor().getEditorInput()).getFile().getProject());
        }
        return new ArrayList<IProject>(selected);
    }

    public static IPackageFragment getPackage(IStructuredSelection selection) {
        Object element = selection.getFirstElement();
        if (element != null && element instanceof IJavaElement) {
            return SelectionUtils.getPackageFragment((IJavaElement)element);
        }
        return null;
    }

    public static IType getType(IStructuredSelection selection) {
        try {
            Object element = selection.getFirstElement();
            if (element instanceof IJavaElement) {
                ICompilationUnit compUnit;
                IType[] types;
                IJavaElement javaElement = (IJavaElement)element;
                IType type = (IType)javaElement.getAncestor(7);
                if (type != null) {
                    return type;
                }
                if (javaElement instanceof ICompilationUnit && (types = (compUnit = (ICompilationUnit)javaElement).getAllTypes()) != null && types.length > 0) {
                    return types[0];
                }
            }
        }
        catch (Exception e) {
            FrameworkCoreActivator.logError((String)"Error getting Java Type from selection", (Throwable)e);
        }
        return null;
    }

    private static IPackageFragment getPackageFragment(IJavaElement element) {
        return (IPackageFragment)element.getAncestor(4);
    }

    public static IPackageFragmentRoot getPackageFragmentRoot(IJavaElement element) {
        return (IPackageFragmentRoot)element.getAncestor(3);
    }
}

